﻿using System;
using System.Globalization;
using System.Windows.Data;

namespace ZegarWPF.ModelWidoku
{
    public enum Wskazówka { Godzinna, Minutowa, Sekundowa };

    public class KonwerterKątaWskazówek : IValueConverter
    {
        public Wskazówka Wskazówka { get; set; } = Wskazówka.Godzinna;

        public object Convert(object value, Type targetType, object parameter,
                              CultureInfo culture)
        {
            DateTime dt = (DateTime)value;
            double wartość = 0;
            switch (Wskazówka)
            {
                case Wskazówka.Godzinna:
                    wartość = dt.Hour;
                    if (wartość >= 12) wartość -= 12;
                    wartość += dt.Minute / 60.0;
                    wartość /= 12.0;
                    break;
                case Wskazówka.Minutowa:
                    wartość = dt.Minute;
                    wartość += dt.Second / 60.0;
                    wartość /= 60.0;
                    break;
                case Wskazówka.Sekundowa:
                    wartość = dt.Second;
                    wartość /= 60.0;
                    break;
            }
            wartość *= 360.0;
            return (object)wartość;
        }

        public object ConvertBack(object value, Type targetType, object parameter,
                                  CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
