﻿using System.Windows;
using System.Windows.Input;
using System.Windows.Interactivity;

namespace ZegarWPF
{
    public class PrzesuwanieOkna : Behavior<Window>
    {
        protected override void OnAttached()
        {
            Window window = this.AssociatedObject;
            if (window != null)
            {
                window.KeyDown += Window_KeyDown;
                window.MouseDown += window_MouseDown;
                window.MouseMove += Window_MouseMove;
                window.MouseUp += window_MouseUp;
            }
        }

        private void Window_KeyDown(object sender, KeyEventArgs e)
        {
            Window window = (Window)sender;
            if (e.Key == Key.Escape) window.Close();
        }

        bool trwaPrzesuwanie = false;
        Point początkowaPozycjaKursora;

        private void window_MouseDown(object sender, MouseEventArgs e)
        {
            Window window = (Window)sender;
            if (!trwaPrzesuwanie && e.LeftButton == MouseButtonState.Pressed)
            {
                trwaPrzesuwanie = true;
                początkowaPozycjaKursora = e.GetPosition(window);
            }
        }

        private void Window_MouseMove(object sender, MouseEventArgs e)
        {
            Window window = (Window)sender;
            if (trwaPrzesuwanie && e.LeftButton == MouseButtonState.Pressed)
            {
                Point pozycjaKursora = e.GetPosition(window);
                Vector przesuniecie = pozycjaKursora - początkowaPozycjaKursora;
                window.Left += przesuniecie.X;
                window.Top += przesuniecie.Y;
            }
        }

        private void window_MouseUp(object sender, MouseEventArgs e)
        {
            Window window = (Window)sender;
            if (e.LeftButton == MouseButtonState.Released)
            {
                trwaPrzesuwanie = false;
            }
        }
    }
}
