﻿using System.ComponentModel;
using System.Windows.Input;

namespace PierwszaAplikacjaWPF.ModelWidoku
{
    public class MójModelWidoku : INotifyPropertyChanged
    {
        private Model.MójModel model = new Model.MójModel() { Wartość = 0 };

        public double Wartość
        {
            get
            {
                return model.Wartość;
            }
            set
            {
                model.Wartość = value;
                onPropertyChanged(nameof(Wartość));
                //onPropertyChanged(nameof(WartośćJakoTekst));
            }
        }

        /*
        public string WartośćJakoTekst //lepiej użyć konwertera
        {
            get
            {
                return Wartość.ToString();
            }
        }
        */

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }

        private ICommand resetuj = null;

        public ICommand Resetuj
        {
            get
            {
                //leniwe inicjowanie
                if (resetuj == null)
                    //resetuj = new PolecenieResetowania(model);
                    resetuj = new RelayCommand(
                        (object parametr) => { Wartość = 0; },
                        (object parametr) => { return Wartość != 0; });                
                return resetuj;
            }
        }
    }
}
