﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace PierwszaAplikacjaWPF.ModelWidoku
{
    public class PolecenieResetowania : ICommand
    {
        public event EventHandler CanExecuteChanged
        {
            add
            {
                CommandManager.RequerySuggested += value;
            }
            remove
            {
                CommandManager.RequerySuggested -= value;
            }
        }

        private Model.MójModel model;        

        public PolecenieResetowania(Model.MójModel model)
        {
            this.model = model;
        }

        public bool CanExecute(object parameter)
        {
            return model.Wartość != 0;
        }

        public void Execute(object parameter)
        {
            model.Wartość = 0;
        }
    }
}
