﻿using System.ComponentModel;
using System.Windows.Input;

namespace TekstWPF.ModelWidoku
{
    public class MójModelWidoku : INotifyPropertyChanged
    {
        private Model.MójModel model = new Model.MójModel();

        public string Tekst
        {
            get
            {
                return model.Tekst;
            }
            set
            {
                model.Tekst = value;
                OnPropertyChanged();
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged()
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(Tekst)));
                //PropertyChanged(this, new PropertyChangedEventArgs(nameof(DługośćTekstu)));
            }
        }

        /*
        public int DługośćTekstu
        {
            get
            {
                return (Tekst == null) ? 0 : Tekst.Length;
            }
        }
        */

        private ICommand usuńTekst;

        public ICommand UsuńTekst
        {
            get
            {
                if (usuńTekst == null)
                    usuńTekst = new RelayCommand(
                        (object p) => { Tekst = ""; },
                        (object p) => { return !string.IsNullOrEmpty(Tekst); });
                return usuńTekst;
            }
        }
    }
}
