﻿namespace AsystenZakupówNowy.Model
{
    public class Sumator
    {
        public decimal Suma { get; private set; } //własność tylko do odczytu
        public decimal Limit { get; private set; }

        public Sumator(decimal limit, decimal suma = 0)
        {
            this.Limit = limit;
            this.Suma = suma;
        }

        public bool Dodaj(decimal kwota)
        {
            if (!sprawdźKwotę(kwota)) return false;
            else
            {
                Suma += kwota;
                return true;
            }
        }

        private bool sprawdźKwotę(decimal kwota)
        {
            if (kwota <= 0) return false;
            if (Suma + kwota > Limit) return false;
            return true;
        }
    }
}
