﻿using System;
using System.Globalization;
using System.Windows.Data;
using System.Windows.Media;

namespace AsystentZakupowWPF
{
    class StringToDecimalConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            try
            {
                string s = (string)value;
                return decimal.Parse(s);
            }
            catch
            {
                return 0M;
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }

    class BooleanToBrushConverter : IValueConverter
    {
        public Brush BrushTrue { get; set; } = Brushes.Black;
        public Brush BrushFalse { get; set; } = Brushes.Red;

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            bool b = (bool)value;
            return b ? BrushTrue : BrushFalse;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
