﻿using System;

namespace AsystentZakupowWPF.Model
{    
    public class Sumator
    {
        //public decimal Suma { get; private set; } //własność tylko do odczytu
        private decimal suma = 0;

        public decimal Suma
        {
            get
            {
                return suma;
            }
            private set
            {
                suma = value;
            }
        }

        public decimal Limit { get; private set; }

        public Sumator(decimal limit, decimal suma = 0)
        {
            this.Limit = limit;
            //this.Suma = suma;
            this.suma = suma;
        }

        public bool Dodaj(decimal kwota)
        {
            if (!SprawdźKwotę(kwota)) return false;
            else
            {
                Suma += kwota;
                return true;
            }
        }

        public bool SprawdźKwotę(decimal kwota)
        {
            if (kwota <= 0) return false;
            if (Suma + kwota > Limit) return false;
            return true;
        }

        public void SprawdźKwotęPrzykładDoTestów(decimal kwota)
        {
            if (!SprawdźKwotę(kwota)) throw new ArgumentException("Niepoprawna wartość", nameof(kwota));
        }
    }
}
