﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media;

namespace KoloryWPF.ModelWidoku
{
    public class EdycjaKoloru : INotifyPropertyChanged
    {
        private Model.Kolor model = new Model.Kolor();

        public byte R
        {
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                onPropertyChanged(nameof(R));
                onPropertyChanged(nameof(Pędzel));
            }
        }

        public byte G
        {
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                onPropertyChanged(nameof(G));
                onPropertyChanged(nameof(Pędzel));
            }
        }

        public byte B
        {
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                onPropertyChanged(nameof(B));
                onPropertyChanged(nameof(Pędzel));
            }
        }

        //nie-za-fajne
        public Brush Pędzel
        {
            get
            {
                return new SolidColorBrush(Color.FromRgb(R, G, B));
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        protected void onPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null)
                PropertyChanged(
                    this,
                    new PropertyChangedEventArgs(nazwaWłasności));
        }
    }
}
