﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Controls;
using System.Windows.Interactivity;
using System.Windows.Media;

namespace PrzykladZachowania
{
    public class SprawdzeniaCzyWpisanaDobraLiczba : Behavior<TextBox>
    {
        protected override void OnAttached()
        {
            base.OnAttached();
            AssociatedObject.TextChanged += AssociatedObject_TextChanged;
        }

        protected override void OnDetaching()
        {
            base.OnDetaching();
            AssociatedObject.TextChanged -= AssociatedObject_TextChanged;
        }

        private void AssociatedObject_TextChanged(object sender, TextChangedEventArgs e)
        {
            //SoundPlayer.Play(dźwięk);
            /*
            try
            {
                decimal liczba = decimal.Parse(AssociatedObject.Text);
                AssociatedObject.Foreground = Brushes.Black;
            }
            catch
            {
                AssociatedObject.Foreground = Brushes.Red;
            }
            */
            decimal liczba;
            bool wynik = decimal.TryParse(AssociatedObject.Text, out liczba);
            //AssociatedObject.Foreground = wynik ? Brushes.Black : Brushes.Red;
            AssociatedObject.Foreground = wynik ? BrushTrue : BrushFalse;
        }

        public Brush BrushTrue { get; set; } = Brushes.Black;
        public Brush BrushFalse { get; set; } = Brushes.Red;
    }
}
