﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Interactivity;

namespace KoloryWPF
{
    //zachowanie "zwykłe"
    class ZamknięcieOknaPoNaciśnięciuKlawisza : Behavior<Window>
    {
        public Key Klawisz { get; set; } = Key.None;
        
        protected override void OnAttached()
        {
            Window window = this.AssociatedObject;
            if(window != null) window.PreviewKeyDown += window_PreviewKeyDown;
        }

        private void window_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Klawisz) this.AssociatedObject.Close();
        }
    }

    //zachowanie z własnością zależności (dependency property)
    class PrzyciskZamykającyOkno : Behavior<Window>
    {
        //public Button Przycisk { get; set; } = null;

        public static readonly DependencyProperty PrzyciskProperty = DependencyProperty.Register(nameof(Przycisk), typeof(Button), typeof(PrzyciskZamykającyOkno), new PropertyMetadata(null, przyciskZmieniony));

        public Button Przycisk
        {
            get
            {
                //DependecyObject
                return (Button)GetValue(PrzyciskProperty);
            }
            set
            {
                SetValue(PrzyciskProperty, value);
            }
        }

        private static void przyciskZmieniony(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            Window window = (d as PrzyciskZamykającyOkno).AssociatedObject;
            //Action<object, RoutedEventArgs>
            RoutedEventHandler przycisk_Click = (object sender, RoutedEventArgs _e) => { window.Close(); };
            if (e.OldValue!=null) (e.OldValue as Button).Click -= przycisk_Click;
            if (e.NewValue != null) (e.NewValue as Button).Click += przycisk_Click;
        }
    }

    //zachowanie doczepione
    //własność doczepiana
    public static class KlawiszWyłączBehavior
    {
        public static readonly DependencyProperty KlawiszProperty =
            DependencyProperty.RegisterAttached(
                "Klawisz",
                typeof(Key),
                typeof(KlawiszWyłączBehavior),
                new PropertyMetadata(Key.None, klawiszZmieniony));

        private static void klawiszZmieniony(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            Key klawisz = (Key)e.NewValue;
            if(d is Window)
            {
                (d as Window).PreviewKeyDown +=
                    (object sender, KeyEventArgs _e) =>
                    {
                        if (_e.Key == klawisz)
                            (d as Window).Close();
                    };
                //powinienem wypisać starą wartość
            }
            else
            {
                //poprawić w czasie przerwy
                (d as UIElement).PreviewKeyDown +=
                    (object sender, KeyEventArgs _e) =>
                    {
                        if (_e.Key == klawisz)
                            (d as UIElement).IsEnabled = false;
                    };
            }
        }

        public static Key GetKlawisz(DependencyObject d)
        {
            return (Key)d.GetValue(KlawiszProperty);
        }

        public static void SetKlawisz(DependencyObject d, Key value)
        {
            d.SetValue(KlawiszProperty, value);
        }
    }
}
