﻿using System.ComponentModel;
using System.Windows.Input;

namespace AsystentZakupówUWP.ModelWidoku
{
    using AsystentZakupówUWP.Model;
    

    public class MójModelWidoku : INotifyPropertyChanged
    {
        //private Sumator model = new Sumator(1000, 0);
        private Sumator model = DAL.Czytaj(1000);

        public decimal Suma
        {
            get
            {
                return model.Suma;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }

        private ICommand dodajKwotę = null;

        public ICommand DodajKwotę
        {
            get
            {
                if(dodajKwotę == null)
                    dodajKwotę = new RelayCommand(
                        (object p) =>
                        {
                            //string s = (string)p;
                            //decimal kwota = decimal.Parse(s);
                            decimal kwota = (decimal)p; //wypudełkowanie
                            model.Dodaj(kwota);
                            onPropertyChanged(nameof(Suma));
                            DAL.Zapisz(model);
                        },
                        (object p) =>
                        {
                            if (p == null) return false;
                            decimal kwota = (decimal)p; //wypudełkowanie
                            return model.SprawdźKwotę(kwota);
                        });
                return dodajKwotę;
            }
        }
    }
}
