﻿
using System;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Interactivity;

namespace Zachowanie
{
    public class ZmienRozmiarCzcionki : Behavior<TextBox>
    {
        public Key Klawisz { get; set; }

        bool ctrlKeyOn;

        protected override void OnAttached()
        {
            base.OnAttached();
            TextBox textbox = this.AssociatedObject;
            if (textbox != null)
            {
                textbox.KeyDown += AssociatedObject_KeyDown;
                textbox.MouseWheel += AssociatedObject_MouseWheel;                
                textbox.KeyUp += AssosiatedObject_KeyUp;
            }
        }

        private void AssosiatedObject_KeyUp(object sender, KeyEventArgs e)
        {
            ctrlKeyOn = false;
        }

        private void AssociatedObject_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Klawisz) ctrlKeyOn = true; 
            else  ctrlKeyOn = false; 
        }

        private void AssociatedObject_MouseWheel(object sender, MouseWheelEventArgs e)
        {
            if (ctrlKeyOn)
            {
                TextBox textbox = (TextBox)sender;
                double rozmiar = textbox.FontSize;
                int dlugoscTekst = textbox.Text.Length;
                rozmiar += (double)(e.Delta / 120);
                if (rozmiar > 8 && dlugoscTekst > 0)
                    textbox.FontSize = rozmiar;                
            }
        }
    }
}
