﻿using Microsoft.Xaml.Behaviors;
using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Windows;

namespace ZegarWPF
{
    public class PrzesuwanieOkna : Behavior<Window>
    {
        protected override void OnAttached()
        {
            Window window = this.AssociatedObject;
            if(window != null)
            {
                window.MouseDown += window_MouseDown;
                window.MouseMove += window_MouseMove;
                window.MouseUp += window_MouseUp;
            }
        }

        private bool trwaPrzesuwanie = false;
        Point początkowaPozycjaKursora;

        private void window_MouseDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            Window window = (Window)sender;
            if(!trwaPrzesuwanie && e.LeftButton == System.Windows.Input.MouseButtonState.Pressed)
            {
                trwaPrzesuwanie = true;
                początkowaPozycjaKursora = e.GetPosition(window);
            }
        }

        private void window_MouseMove(object sender, System.Windows.Input.MouseEventArgs e)
        {
            Window window = (Window)sender;
            if(trwaPrzesuwanie)
            {
                Point pozycjaKursora = e.GetPosition(window);
                Vector przeunięcie = pozycjaKursora - początkowaPozycjaKursora;
                window.Left += przeunięcie.X;
                window.Top += przeunięcie.Y;
            }
        }

        private void window_MouseUp(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            Window window = (Window)sender;
            if(trwaPrzesuwanie && e.LeftButton == System.Windows.Input.MouseButtonState.Released)
            {
                trwaPrzesuwanie = false;
            }
        }
    }
}
