using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

//using System.Collections;
using System.IO;
using System.Threading;

namespace Notatnik.NET
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }                    

        private void pasekstanuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pasekstanuToolStripMenuItem.Checked = !pasekstanuToolStripMenuItem.Checked;
            statusStrip1.Visible = pasekstanuToolStripMenuItem.Checked;
        }

        public static string[] CzytajPlikTekstowy(string nazwaPliku)
        {
            List<string> tekst=new List<string>();            
            try
            {
                using (StreamReader sr = new StreamReader(nazwaPliku))
                {
                    string wiersz;
                    while ((wiersz = sr.ReadLine()) != null)
                        tekst.Add(wiersz);
                }                
                return tekst.ToArray();
            }
            catch (Exception e)
            {
                //MessageBox.Show("Bd odczytu pliku " + nazwaPliku + " (" + e.Message + ")");
                MessageBox.Show("Bd odczytu pliku " + nazwaPliku + "\nOpis wyjtku: " + e.Message,
                    "Notatnik.NET - Bd przy wczytywaniu pliku", MessageBoxButtons.OK, MessageBoxIcon.Error);

                return null;
            }
        }

        public static void ZapiszDoPlikuTekstowego(string nazwaPliku,string[] tekst)
        {
            using (StreamWriter sw = new StreamWriter(nazwaPliku))
            {
                foreach (string wiersz in tekst)
                    sw.WriteLine(wiersz);
            }
        }        

        private void otwrzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                string nazwaPliku=openFileDialog1.FileName;
                textBox1.Lines = CzytajPlikTekstowy(nazwaPliku);
                int ostatniSlash=nazwaPliku.LastIndexOf('\\');
                toolStripStatusLabel1.Text = nazwaPliku.Substring(ostatniSlash+1, nazwaPliku.Length - ostatniSlash - 1);
            }
        }

        private void zapiszjakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string nazwaPliku = openFileDialog1.FileName;
            if (nazwaPliku.Length > 0) saveFileDialog1.FileName = nazwaPliku;
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                nazwaPliku = saveFileDialog1.FileName;
                ZapiszDoPlikuTekstowego(nazwaPliku, textBox1.Lines);
                int ostatniSlash = nazwaPliku.LastIndexOf('\\');
                toolStripStatusLabel1.Text = nazwaPliku.Substring(ostatniSlash + 1, nazwaPliku.Length - ostatniSlash - 1);
            }	
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Undo();
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Cut();
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Paste();
        }

        private void usuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = "";
        }

        private void zaznaczwszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
        }

        private void toolStripMenuItem1_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox1.Font;
            if (fontDialog1.ShowDialog() == DialogResult.OK)
                textBox1.Font = fontDialog1.Font;
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox1.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
                textBox1.BackColor = colorDialog1.Color;
        }

        //pole wykorzystywane do drukowania
        StringReader sr = null;

        private void printDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            Font czcionka = textBox1.Font;
            int wysokoscWiersza=(int)czcionka.GetHeight(e.Graphics);
            int iloscLinii=e.MarginBounds.Height/wysokoscWiersza;

            //pierwsza strona - dzielenie linii (dbamy o zachowanie wyrazow)
            if (sr == null)
            {
                string tekst = "";
                foreach (string wiersz in textBox1.Lines)
                {
                    float szerokosc = e.Graphics.MeasureString(wiersz, czcionka).Width;
                    if (szerokosc < e.MarginBounds.Width)
                    {
                        tekst += wiersz + "\n";
                    }
                    else
                    {
                        float sredniaSzerokoscLitery = szerokosc / wiersz.Length;
                        int ileLiterWWierszu = (int)(e.MarginBounds.Width / sredniaSzerokoscLitery);
                        /*
                        //brut force
                        int ileRazy = wiersz.Length/ileLiterWWierszu;                    
                        for (int i=0;i<ileRazy;i++)
                        {                        
                            tekst+=wiersz.Substring(i*ileLiterWWierszu,ileLiterWWierszu)+"\n";
                        }
                        */
                        //bez dzielenia wyrazow
                        string skracanyWiersz = wiersz;
                        do
                        {
                            int ostatniaSpacja = skracanyWiersz.Substring(0, ileLiterWWierszu).LastIndexOf(' ');
                            int iloscLiter = ostatniaSpacja!=-1?Math.Min(ostatniaSpacja, ileLiterWWierszu):ileLiterWWierszu;
                            tekst += skracanyWiersz.Substring(0, iloscLiter) + "\n";
                            skracanyWiersz = skracanyWiersz.Substring(iloscLiter).TrimStart(' '); //pozostala czesc
                        } while (skracanyWiersz.Length > ileLiterWWierszu);
                        tekst += skracanyWiersz + "\n"; //ostatnia czesc
                    } //if-else
                } //foreach
                sr = new StringReader(tekst);
            } //if (sr==null)

            e.HasMorePages = true;
            for(int i=0;i<iloscLinii;i++)
            {
                string wiersz = sr.ReadLine();
                if (wiersz == null)
                {
                    e.HasMorePages = false;
                    sr = null;
                    break;                    
                }
                e.Graphics.DrawString(wiersz,
                                      czcionka,          
                                      Brushes.Black,     
                                      e.MarginBounds.Left,                     //x
                                      e.MarginBounds.Top+i*wysokoscWiersza);   //y
            }
        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {
            if (printDialog1.ShowDialog()==DialogResult.OK)
            {
                printDocument1.DocumentName = "Notatnik.NET - " + toolStripStatusLabel1.Text;                
                
                //Drukowanie w biezacym watku
                //printDocument1.Print();

                //Drukowanie w tle
                Thread watek = new Thread(new ThreadStart(printDocument1.Print));
                watek.IsBackground = true;
                watek.Start();                
            }
        }

        private void toolStripMenuItem5_Click(object sender, EventArgs e)
        {
            printPreviewDialog1.ShowDialog();
        }

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            pageSetupDialog1.ShowDialog();
        }
    }
}