using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Diagnostics;

namespace Procesy
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();            

            //Tytu okna
            Text = "Lista procesw na " + System.Environment.MachineName;

            try
            {
                //Pobieranie i wywietlanie listy uruchomionych procesw
                Process[] procesy = Process.GetProcesses();
                foreach (Process proces in procesy)
                {
                    if (proces.Id == 0) continue; //Proces bezczynnoci systemu
                    string opis = "" + proces.Id + "\t" + proces.BasePriority + "\t" + proces.StartTime + "\t" + proces.TotalProcessorTime + "\t" + proces.Threads.Count + "\t";
                    string tytul = proces.MainWindowTitle;
                    opis += ((tytul == "") ? proces.ProcessName.ToUpper() : tytul);
                    listBox1.Items.Add(opis);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Bd: " + ex.Message, "Procesy", MessageBoxButtons.OK, MessageBoxIcon.Error);
                throw ex; //obiekt okna nie powstanie
            }
        }
    }
}