using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

//dodane
using System.Collections;
using System.IO;

namespace PlikiTekstowe
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        public static string[] CzytajPlikTekstowy(string nazwaPliku)
        {
            ArrayList tekst = new ArrayList();
            try
            {
                using (StreamReader sr = new StreamReader(nazwaPliku))
                {
                    string wiersz;
                    while ((wiersz = sr.ReadLine()) != null)
                        tekst.Add(wiersz);
                }
                return (string[])tekst.ToArray(typeof(string));
            }
            catch (Exception e)
            {
                MessageBox.Show("Bd odczytu pliku " + nazwaPliku+" ("+e.Message+")");
                return null;
            }
        }

        private void fileListBox1_FileDoubleClicked(object sender, EventArgs e, string fileName)
        {
            textBox1.Lines = CzytajPlikTekstowy(fileName);
            if (textBox1.Lines != null)
                Text = "Przegldarka plikw tesktowych - " + fileName.Substring(fileName.LastIndexOf('\\')+1);
        }

        const int prog = 30; //wielkosc przesuniecia konieczna do zainicjowania operacji d&d
        private bool przeciaganie = false;
        private Point pozycjaMyszki=new Point();

        private void fileListBox1_MouseDown(object sender, MouseEventArgs e)
        {
            if (File.Exists(fileListBox1.FileName))
            {
                przeciaganie = true;
                pozycjaMyszki = e.Location;
            }
        }

        private void fileListBox1_MouseUp(object sender, MouseEventArgs e)
        {
            przeciaganie = false;
        }

        private void fileListBox1_MouseMove(object sender, MouseEventArgs e)
        {
            if (!przeciaganie) return;
            int dx = e.Location.X - pozycjaMyszki.X;
            int dy = e.Location.Y - pozycjaMyszki.Y;
            if (Math.Sqrt(dx * dx + dy * dy) > prog)
            {
                fileListBox1.DoDragDrop(fileListBox1.FileName, DragDropEffects.All);
                przeciaganie = false;
            }
        }

        private void textBox1_DragOver(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.Copy;
        }

        private void textBox1_DragDrop(object sender, DragEventArgs e)
        {
            fileListBox1_FileDoubleClicked(null, null, fileListBox1.FileName);
        }
    }
}