﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Microsoft.Win32;

namespace Rejestr
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            label1.Text = sciezkaMojeDokumenty();
        }

        #region Katalogi specjalne
        private string pobierzSciezkeDoKataloguSpecjalnego(string nazwaWartosci)
        {
            const string nazwaKlucza = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
            try
            {
                RegistryKey rejestr = Registry.CurrentUser.OpenSubKey(nazwaKlucza);
                if (rejestr == null) throw new Exception("brak klucza '" + nazwaKlucza + "'");
                string sciezkaKatalogu = (string)rejestr.GetValue(nazwaWartosci);
                if (sciezkaKatalogu == null)
                    throw new Exception("brak wartosci '" + nazwaWartosci + "'");
                rejestr.Close();
                return sciezkaKatalogu;
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd przy czytaniu rejestru: " + exc.Message + ".", this.Text);
                return null;
            }
        }

        private string sciezkaMojeDokumenty()
        {
            return pobierzSciezkeDoKataloguSpecjalnego("Personal");
        }
        #endregion

        #region Polozenie okna
        const string kluczAplikacji = "Software\\Helion\\PrzykladRejestr";
        bool czyZapisywacPolozenieOkna = true;

        private void czytajPolozenieOkna(string nazwaKlucza)
        {
            RegistryKey rejestr = Registry.CurrentUser.OpenSubKey(nazwaKlucza);
            if (rejestr == null)
            {
                //tu mozna umiescic polecenia wykonywane przy pierwszym uruchomieniu aplikacji
                MessageBox.Show("Pierwsze uruchomienie programu.", this.Text);
                return;
            }
            //x
            object wartosc = rejestr.GetValue("left");
            if (wartosc != null) this.Left = (int)wartosc;
            //y
            wartosc = rejestr.GetValue("top");
            if (wartosc != null) this.Top = (int)wartosc;
            //szer
            wartosc = rejestr.GetValue("width");
            if (wartosc != null) this.Width = (int)wartosc;
            //wys
            wartosc = rejestr.GetValue("height");
            if (wartosc != null) this.Height = (int)wartosc;
            rejestr.Close();
        }

        private void zapiszPolozenieOkna(string nazwaKlucza)
        {
            RegistryKey rejestr = Registry.CurrentUser.OpenSubKey(nazwaKlucza, true);
            if (rejestr == null)
            {
                MessageBox.Show("Tworzę klucz rejestru dla aplikacji", this.Text);
                rejestr = Registry.CurrentUser.CreateSubKey(nazwaKlucza);
            }
            rejestr.SetValue("left", this.Left);
            rejestr.SetValue("top", this.Top);
            rejestr.SetValue("width", this.Width);
            rejestr.SetValue("height", this.Height);
            rejestr.Close();
        }
        #endregion

        private void Form1_Load(object sender, EventArgs e)
        {
            try
            {
                czytajPolozenieOkna(kluczAplikacji);
            }
            catch (Exception ex)
            {
                MessageBox.Show("Błąd przy odtwarzaniu położenia okna:\n" + ex.Message);
            }
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (czyZapisywacPolozenieOkna) zapiszPolozenieOkna(kluczAplikacji);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Registry.CurrentUser.DeleteSubKey(kluczAplikacji, false);
            czyZapisywacPolozenieOkna = false; 
        }
    }
}
