﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using static JacekMatulewski.PInvoke.WinAPI;
using static JacekMatulewski.PInvoke.WinAPIHelper;
using HWND = System.IntPtr;

namespace PInvoke
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            string katalogGlownyDysku = System.Environment.GetLogicalDrives()[0]; //"C:\\"
            int procentZajetosci = WolneMiejsceNaDysku(katalogGlownyDysku);
            if (procentZajetosci >= 0) progressBar1.Value = procentZajetosci;

            SetProcessDPIAware();
            checkBox1.Checked = true;

            cbStanOkna.SelectedIndex = 1;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            MessageBeep(0);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            MessageBeep(48);
        }

        private void button8_Click(object sender, EventArgs e)
        {
            _MessageBox(this.Handle, "Polskie litery: ąćęłńóśżź", "Tytuł", 64);
            MessageBox.Show("Polskie litery: ąćęłńóśżź", "Tytuł", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            //uint wynik = WinExec(textBox1.Text, StanOkna.Normalme);
            uint wynik = WinExec(textBox1.Text, (StanOkna)cbStanOkna.SelectedIndex);
            if (wynik <= 31)
                MessageBox.Show("Błąd " + wynik + "! Nie udało się uruchomić " + textBox1.Text);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            const int MAX_PATH = 260;
            StringBuilder katalogWindows = new StringBuilder(MAX_PATH);
            uint rozmiar = (uint)katalogWindows.Capacity;
            GetWindowsDirectory(katalogWindows, rozmiar);
            MessageBox.Show(katalogWindows.ToString());
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            timer1.Enabled = checkBox1.Checked;
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            Point pozycjaKursora = Cursor.Position;
            //https://msdn.microsoft.com/pl-pl/library/aa970067(v=vs.110).aspx
            //Do not use Cursor.Position. The behavior of this property outside client windows in a scaled environment is undefined.

            //GetCursorPos(ref pozycjaKursora);
            GetPhysicalCursorPos(ref pozycjaKursora);

            label3.Text = pozycjaKursora.ToString();
            panel1.BackColor = PobierzKolorPiksela(pozycjaKursora);
        }

        private void button9_Click(object sender, EventArgs e)
        {
            Bitmap zrzutEkranu = PobierzZrzutOkna(this.Handle, false);
            pictureBox1.Image = zrzutEkranu;
        }

        private void button10_Click(object sender, EventArgs e)
        {
            //Bitmap zrzutEkranu = _PobierzZrzutEkranu();
            Bitmap zrzutEkranu = PobierzZrzutEkranu();
            pictureBox1.Image = zrzutEkranu;
        }

        Bitmap PobierzZrzutEkranuNet(Screen ekran = null)
        {
            if (ekran == null) ekran = Screen.PrimaryScreen;
            Bitmap zrzutEkranu = new Bitmap(ekran.Bounds.Width, ekran.Bounds.Height);
            using (Graphics graphics = Graphics.FromImage(zrzutEkranu))
            {
                graphics.CopyFromScreen(
                    ekran.Bounds.X, ekran.Bounds.Y,
                    0, 0,
                    zrzutEkranu.Size,
                    CopyPixelOperation.SourceCopy);
            }
            return zrzutEkranu;
        }

        private void button11_Click(object sender, EventArgs e)
        {
            Bitmap zrzutEkranu = PobierzZrzutEkranuNet();
            pictureBox1.Image = zrzutEkranu;
        }

        private void label4_Click(object sender, EventArgs e)
        {
            Process.Start(label4.Text);
        }

        private void button5_Click(object sender, EventArgs e)
        {
            Process[] procesy = Process.GetProcesses();

            string s = "Lista otwartych okien:\n";
            int licznik = 0;
            foreach (Process proces in procesy)
            {
                if (!string.IsNullOrEmpty(proces.MainWindowTitle))
                {
                    licznik++;
                    s += $"{licznik}. proces: {proces.ProcessName}, ID: {proces.Id}, tytuł okna: {proces.MainWindowTitle}, uchwyt okna: {proces.MainWindowHandle}\n";
                }
            }
            MessageBox.Show(s);
        }

        private void button6_Click(object sender, EventArgs e)
        {
            IDictionary<HWND, InformacjeOOknie> okna = PobierzListęOkien();

            string s = "Lista otwartych okien:\n";
            int licznik = 0;
            foreach (KeyValuePair<HWND, InformacjeOOknie> okno in okna)
            {
                if (!string.IsNullOrEmpty(okno.Value.Tytuł))
                {
                    licznik++;
                    InformacjeOOknie info = okno.Value;
                    s += $"{licznik}. tytuł okna: {info.Tytuł}, uchwyt okna: {info.Uchwyt}, położenie: {info.Położenie.ToString()}\n";
                }
            }
            MessageBox.Show(s);
        }

        private void button7_Click(object sender, EventArgs e)
        {
            IDictionary<HWND, InformacjeOOknie> okna = PobierzListęOkienDzieci(this.Handle);

            string s = $"Lista otwartych okien dzieci okna {this.Handle}:\n";
            int licznik = 0;
            foreach (KeyValuePair<HWND, InformacjeOOknie> okno in okna)
            {
                if (!string.IsNullOrEmpty(okno.Value.Tytuł))
                {
                    licznik++;
                    InformacjeOOknie info = okno.Value;
                    s += $"{licznik}. tytuł okna: {info.Tytuł}, uchwyt okna: {info.Uchwyt}, położenie: {info.Położenie.ToString()}\n";
                }
            }
            MessageBox.Show(s);
        }

        private void button12_Click(object sender, EventArgs e)
        {
            string nazwaOkna = textBox2.Text;
            HWND uchwyt = FindWindow(null, nazwaOkna);
            if (uchwyt == HWND.Zero)
                MessageBox.Show("Nie ma okna o tytule \"" + nazwaOkna + "\"");
            else
                MessageBox.Show("Uchwyt pierwszego znalezionego okna o tytule \"" + nazwaOkna + "\" to " + uchwyt.ToString());
        }

        private void button13_Click(object sender, EventArgs e)
        {
            string nazwaOkna = textBox2.Text;
            HWND uchwyt = FindWindow(null, nazwaOkna);
            if (uchwyt != HWND.Zero) SendMessage(uchwyt, WM_CLOSE, 0, 0);
            else MessageBox.Show("Nie ma okna o tytule \"" + nazwaOkna + "\"");
        }

        protected override void WndProc(ref Message m)
        {
            if (m.Msg != 308) listBox1.Items.Add(m.Msg);

            switch (m.Msg)
            {
                case WM_NCMOUSEMOVE:
                    long lParam = (long)m.LParam;
                    long x = lParam & 0x0000FFFF;
                    long y = (lParam & 0xFFFF0000) >> 16;
                    label5.Text = "(Komunikat) Mysz poza obszarem klienta: " + x + "," + y;
                    break;
            }

            base.WndProc(ref m);
        }
    }
}
