﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;

using static JacekMatulewski.PInvoke.WinAPI;
using HWND = System.IntPtr;

namespace JacekMatulewski.PInvoke
{
    public static class WinAPIHelper
    {
        public static int WolneMiejsceNaDysku(string katalogGlownyDysku)
        {
            int wolneMiejsceNaDyskuProcenty;
            long wolneMiejsceDlaUzytkownika = 0;
            long rozmiarDysku = 0;
            long wolneMiejsceNaDysku = 0;
            if (GetDiskFreeSpaceEx(katalogGlownyDysku,
                  ref wolneMiejsceDlaUzytkownika,
                  ref rozmiarDysku,
                  ref wolneMiejsceNaDysku))
            {
                wolneMiejsceNaDyskuProcenty = (int)(100 * (rozmiarDysku - wolneMiejsceNaDysku) / (double)rozmiarDysku);
            }
            else
            {
                wolneMiejsceNaDyskuProcenty = -1;
            }
            return wolneMiejsceNaDyskuProcenty;
        }

        #region getColorAt
        private static Bitmap pikselEkranu = new Bitmap(1, 1, System.Drawing.Imaging.PixelFormat.Format32bppArgb);

        //Hubert Wojtowicz
        public static Color PobierzKolorPiksela(Point położenie)
        {
            //gs - grafika źródło
            //gd - grafika celu
            using (Graphics gd = Graphics.FromImage(pikselEkranu)) // tworzymy obiekt klasy Graphics z pixela
            {
                using (Graphics gs = Graphics.FromHwnd(IntPtr.Zero)) // tworzymy pusty obiekt klasy Graphics 
                {
                    IntPtr hsDC = gs.GetHdc(); // wskaznik do grafiki source
                    IntPtr hdDC = gd.GetHdc(); // wsskaznik do grafiki destination

                    //BitBlt(wskaźnik do pixela, x-wsp, y-wsp, szerokość, wysokość, wsp x pobieranego miejsca, wsp y pob miejsca
                    BitBlt(hdDC, 0, 0, 1, 1, hsDC, położenie.X, położenie.Y, (int)CopyPixelOperation.SourceCopy);

                    // zeruje wkazniki
                    gd.ReleaseHdc();
                    gs.ReleaseHdc();
                }
            }

            // zwracamy odczytany kolor pixela
            return pikselEkranu.GetPixel(0, 0);
        }
        #endregion

        public static Bitmap PobierzZrzutOkna(IntPtr uchwytOkna, bool tylkoObszarKlienta = false)
        {
            RECT obszar = new RECT();
            GetWindowRect(uchwytOkna, out obszar);
            Bitmap bitmap = new Bitmap(obszar.Right - obszar.Left, obszar.Bottom - obszar.Top);
            using (Graphics graphics = Graphics.FromImage(bitmap))
            {
                PrintWindow(uchwytOkna, graphics.GetHdc(), tylkoObszarKlienta?1:0);
            }

            return bitmap;
        }

        public static Bitmap _PobierzZrzutEkranu() //nie działa!
        {
            return PobierzZrzutOkna(GetDesktopWindow(), true);
        }

        public static Bitmap PobierzZrzutEkranu()
        {
            RECT obszar = new RECT();
            GetWindowRect(GetDesktopWindow(), out obszar);
            Bitmap bitmap = new Bitmap(obszar.Right - obszar.Left, obszar.Bottom - obszar.Top);
            using (Graphics graphics = Graphics.FromImage(bitmap)) // tworzymy obiekt klasy Graphics z pixela
            {
                using (Graphics gsrc = Graphics.FromHwnd(IntPtr.Zero)) // tworzymy pusty obiekt klasy Graphics 
                {
                    IntPtr hSrcDC = gsrc.GetHdc(); // wskaznik do grafiki source
                    IntPtr hDC = graphics.GetHdc(); // wsskaznik do grafiki destination

                    //BitBlt(wskaźnik do pixela, x-wsp, y-wsp, szerokość, wysokość, wsp x pobieranego miejsca, wsp y pob miejsca
                    BitBlt(hDC, 0, 0, obszar.Right - obszar.Left, obszar.Bottom - obszar.Top, hSrcDC, 0, 0, (int)CopyPixelOperation.SourceCopy);

                    // zeruje wkazniki
                    graphics.ReleaseHdc();
                    gsrc.ReleaseHdc();
                }
            }

            // zwracamy odczytany kolor pixela
            return bitmap;
        }

        public class InformacjeOOknie
        {
            public HWND Uchwyt;
            public string Tytuł;
            public Rectangle Położenie;
        }

        //http://www.tcx.be/blog/2006/list-open-windows/
        public static IDictionary<HWND, InformacjeOOknie> PobierzListęOkien(bool tylkoWidoczneOkna = true)
        {
            HWND shellWindow = GetShellWindow();
            Dictionary<HWND, InformacjeOOknie> okna = new Dictionary<HWND, InformacjeOOknie>();

            EnumWindows(
                (HWND hWnd, int lParam) =>
                {
                    if (hWnd == shellWindow) return true;
                    if (tylkoWidoczneOkna && !IsWindowVisible(hWnd)) return true;

                    int długośćTytułu = GetWindowTextLength(hWnd);
                    if (długośćTytułu == 0) return true;

                    StringBuilder sb = new StringBuilder(długośćTytułu);
                    GetWindowText(hWnd, sb, długośćTytułu + 1);

                    RECT rect;
                    GetWindowRect(hWnd, out rect);

                    InformacjeOOknie info = new InformacjeOOknie()
                    {
                        Uchwyt = hWnd,
                        Tytuł = sb.ToString(),
                        Położenie = rect.ToRectangle()
                    };
                    okna[hWnd] = info;
                    return true;
                },
                IntPtr.Zero);

            return okna;
        }

        public static Rectangle ToRectangle(this RECT rect)
        {
            return new Rectangle(rect.Left, rect.Top, rect.Right - rect.Left, rect.Bottom - rect.Top);
        }

        public static IDictionary<HWND, InformacjeOOknie> PobierzListęOkienDzieci(HWND uchwytOkna)
        {
            Dictionary<HWND, InformacjeOOknie> okna = new Dictionary<HWND, InformacjeOOknie>();

            EnumChildWindows(
                uchwytOkna,
                (HWND hWnd, int lParam) =>
                {
                    int długośćTytułu = GetWindowTextLength(hWnd);
                    if (długośćTytułu == 0) return true;

                    StringBuilder sb = new StringBuilder(długośćTytułu);
                    GetWindowText(hWnd, sb, długośćTytułu + 1);

                    RECT rect;
                    GetWindowRect(hWnd, out rect);

                    InformacjeOOknie info = new InformacjeOOknie()
                    {
                        Uchwyt = hWnd,
                        Tytuł = sb.ToString(),
                        Położenie = rect.ToRectangle()
                    };
                    okna[hWnd] = info;
                    return true;
                },
                IntPtr.Zero);

            return okna;
        }
    }
}
