//---------------------------------------------------------------------------

#include <vcl.h>

#pragma hdrstop

#include "KontrolaAplikacji.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//

static inline void ValidCtrCheck(TControlProcess *)
{
	new TControlProcess(NULL);
}
//---------------------------------------------------------------------------
__fastcall TControlProcess::TControlProcess(TComponent* Owner)
	: TCreateProcess(Owner)
{
}
//---------------------------------------------------------------------------
namespace Kontrolaaplikacji
{
	void __fastcall PACKAGE Register()
	{
		TComponentClass classes[1] = {__classid(TControlProcess)};
		RegisterComponents("JM", classes, 0);
	}
}
//---------------------------------------------------------------------------

bool __fastcall TControlProcess::Execute()
{
	const int CzasUruchomienia=60; //w sekundach

	//Nie mozna uruchomic drugiej aplikacji
	if (IsExecuted) throw Exception("Aplikacja jest juz uruchomiona.");
	//Wywolywanie TCreateProcess.Execute
	bool Wynik=TCreateProcess::Execute();
	//Czekanie na zakonczenie inicjacji aplikacji (nie dziala np. dla cmd.exe)
	switch (WaitForInputIdle(ProcessInformation.hProcess,1000*CzasUruchomienia))
	{
		case 0: Wynik=true; break;
		case WAIT_FAILED:
		case WAIT_TIMEOUT: Wynik=false; break;
	}
	return Wynik;
}

void TControlProcess::BringToFront()
{
	if (IsExecuted) BringWindowToTop(WindowHandle);
}

void TControlProcess::Terminate()
{
	if (IsExecuted) TerminateProcess(ProcessInformation.hProcess,0);
	memset(&FProcessInformation,0,sizeof(FProcessInformation)); //czysci ProcessInformation
}

bool __fastcall TControlProcess::GetExecuted()
{
	if (WindowHandle==0) //aplikacja zostala zamknieta
	{
		FProcessInformation.dwProcessId=0;
		FProcessInformation.hProcess=0;
		FProcessInformation.dwThreadId=0;
		FProcessInformation.hThread=0;
	}
	if (ProcessInformation.dwProcessId==0)
	{
		return false;
	}
	else return true;
}

HWND __fastcall TControlProcess::GetWindowHandle()
{
	return GetMainWindowHandle(ProcessInformation.dwProcessId);
}

TPriorities __fastcall TControlProcess::GetPriority()
{
	if (!IsExecuted) FPriority=(TPriorities)GetPriorityClass(ProcessInformation.hProcess);
	return FPriority;
}

void __fastcall TControlProcess::SetPriority(TPriorities APriority)
{
	if (!IsExecuted) FPriority=APriority;
	else
		if (SetPriorityClass(ProcessInformation.hProcess,(long)APriority))
			FPriority=APriority;
}

//To dziala tylko po uruchomieniu aplikacji
AnsiString __fastcall TControlProcess::GetCaption()
{
	const int MAX_COUNT=256;
	char LCaption[MAX_COUNT];
	if (!IsExecuted) return NULL;
	GetWindowText(WindowHandle,LCaption,MAX_COUNT);
	return (AnsiString)LCaption;
}

void __fastcall TControlProcess::SetCaption(AnsiString ACaption)
{
	if (!IsExecuted) return;
	SetWindowText(WindowHandle,ACaption.c_str());
}

void TControlProcess::PobierzPozycjeOkna()
{
	TWindowPlacement ustawieniaOkna;
	GetWindowPlacement(WindowHandle,&ustawieniaOkna);
	FLeft=ustawieniaOkna.rcNormalPosition.left;
	FTop=ustawieniaOkna.rcNormalPosition.top;
	FWidth=ustawieniaOkna.rcNormalPosition.right-ustawieniaOkna.rcNormalPosition.left;
	FHeight=ustawieniaOkna.rcNormalPosition.bottom-ustawieniaOkna.rcNormalPosition.top;
	FWindowStyle=(TWindowStyles)ustawieniaOkna.showCmd;
}

void TControlProcess::UstawPozycjeOkna()
{
	TWindowPlacement ustawieniaOkna;
	ustawieniaOkna.rcNormalPosition.left=FLeft;
	ustawieniaOkna.rcNormalPosition.top=FTop;
	ustawieniaOkna.rcNormalPosition.right=FLeft+FWidth;
	ustawieniaOkna.rcNormalPosition.bottom=FTop+FHeight;
	ustawieniaOkna.showCmd=(int)FWindowStyle;
	ustawieniaOkna.length=sizeof(ustawieniaOkna);
	SetWindowPlacement(WindowHandle,&ustawieniaOkna);
}

int __fastcall TControlProcess::GetLeft()
{
	if (IsExecuted) PobierzPozycjeOkna();
	return FLeft;
}

int __fastcall TControlProcess::GetTop()
{
	if (IsExecuted) PobierzPozycjeOkna();
	return FTop;
}

int __fastcall TControlProcess::GetWidth()
{
	if (IsExecuted) PobierzPozycjeOkna();
	return FWidth;
}

int __fastcall TControlProcess::GetHeight()
{
	if (IsExecuted) PobierzPozycjeOkna();
	return FHeight;
}

TWindowStyles __fastcall TControlProcess::GetWindowStyle()
{
	if (IsExecuted) PobierzPozycjeOkna();
	return FWindowStyle;
}

void __fastcall TControlProcess::SetLeft(int ALeft)
{
	FLeft=ALeft;
	if (IsExecuted) UstawPozycjeOkna();
}

void __fastcall TControlProcess::SetTop(int ATop)
{
	FTop=ATop;
	if (IsExecuted) UstawPozycjeOkna();
}

void __fastcall TControlProcess::SetWidth(int AWidth)
{
	FWidth=AWidth;
	if (IsExecuted) UstawPozycjeOkna();
}

void __fastcall TControlProcess::SetHeight(int AHeight)
{
	FHeight=AHeight;
	if (IsExecuted) UstawPozycjeOkna();
}

void __fastcall TControlProcess::SetWindowStyle(TWindowStyles AWindowStyle)
{
	FWindowStyle=AWindowStyle;
	if (IsExecuted) UstawPozycjeOkna();
}

