//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "Unit2.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

/*
Kod oparty na projektach przygotowanych przez Sawomira Wawrzyniaka i Michaa Gajewskiego
*/

Graphics::TBitmap* ZrzutEkranu(Graphics::TBitmap* bmp)
{
    TRect calyEkran = Rect(0, 0, Screen->Width, Screen->Width);

    TCanvas* pulpitPlotno = new TCanvas();
    pulpitPlotno->Handle = GetDC(0);
    bmp->Width = Screen->Width;
    bmp->Height = Screen->Height;
    bmp->Canvas->CopyRect(calyEkran, pulpitPlotno, calyEkran);
    delete pulpitPlotno;

    return bmp;
}


__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
    ZrzutEkranu(Image1->Picture->Bitmap); //zrobione ju tutaj bedzie bez okna tej aplikacji

    //warstwa przezroczysta z ramkami
    Image2->Stretch=true;
    Image2->Picture->Bitmap->Width=Image1->Picture->Bitmap->Width;
    Image2->Picture->Bitmap->Height=Image1->Picture->Bitmap->Height;
    Image2->Transparent=true;
    Image2->Picture->Bitmap->TransparentColor=clWhite;
    //Image2->Picture->Bitmap->Transparent=true;
    //Image2->Picture->Bitmap->TransparentColor=(TColor)RGB(255,255,255);

    //login biecego uytkownika
    DWORD rozmiarLoginu = 256;
    GetUserName(loginBiezacegoUzytkownika,&rozmiarLoginu);
    //ShowMessage(loginBiezacegoUzytkownika);
    CheckBox2->Caption=CheckBox2->Caption+" (login: "+loginBiezacegoUzytkownika+")";

    Button1Click(this);
}
//---------------------------------------------------------------------------

//ustalanie listy okien
void __fastcall TForm1::Button1Click(TObject *Sender)
{
    ZrzutEkranu(Image1->Picture->Bitmap);

    //Beep(100,100);
    Screen->Cursor=crHourGlass;

    //usuwanie danych przypisanych do wezlow TreeView
    try
    {
    for(int i=0;i<TreeView1->Items->Count;++i)
        if(TreeView1->Items->Item[i]->Data!=NULL)
        {
            delete TreeView1->Items->Item[i]->Data;
            TreeView1->Items->Item[i]->Data=NULL;
        }
    }
    catch(...)
    {
        Beep(100,100);
    }

    TreeView1->Items->Clear();
    TreeView1->Items->BeginUpdate();

    ElementyOpisu elementyOpisu;
    elementyOpisu.uchwyt=CheckBox4->Checked;
    elementyOpisu.tytulOkna=CheckBox5->Checked;
    elementyOpisu.nazwaKlasyOkna=CheckBox6->Checked;
    elementyOpisu.wlascicielProcesu=CheckBox7->Checked;

    LParam_EnumWindowProc lParam_Lista;
    lParam_Lista.tylkoWidoczneOkna = CheckBox1->Checked;
    lParam_Lista.tylkoOknaBiezacegoUzytkownika = CheckBox2->Checked;
    lParam_Lista.tylkoGlowneOkna = CheckBox3->Checked;
    lParam_Lista.treeViewItems=TreeView1->Items;
    lParam_Lista.elementyOpisu=elementyOpisu;
    strcpy(lParam_Lista.loginBiezacegoUzytkownika,loginBiezacegoUzytkownika);

    EnumWindows((WNDENUMPROC)EnumWindowsProc,(LPARAM)&lParam_Lista);

    TreeView1->Items->EndUpdate();
    Screen->Cursor=crDefault;
    Label1->Caption="Lista okien ("+IntToStr(TreeView1->Items->Count)+"):";

    ZapelnijTabele();

    //Beep(300,100);

    TreeView1->Selected=TreeView1->Items->GetFirstNode();
    //TShiftState ss;
    //TreeView1->Select(TreeView1->Items->GetFirstNode(),ss);
}
//---------------------------------------------------------------------------

AnsiString UsunNawiasyKwadratoweZPoczatkuLancucha(AnsiString tekst)
{
    int numerPierwszejLiteryZaNawiasem=tekst.LastDelimiter("]")+1;
    int dlugosc=tekst.Length();
    tekst = tekst.SubString(numerPierwszejLiteryZaNawiasem,dlugosc-numerPierwszejLiteryZaNawiasem);
    return tekst.TrimLeft();
}

void __fastcall TForm1::Button2Click(TObject *Sender)
{
    TreeView1->AlphaSort(false);
    ZapelnijTabele();
}
//---------------------------------------------------------------------------


void __fastcall TForm1::TreeView1Compare(TObject *Sender, TTreeNode *Node1,
      TTreeNode *Node2, int Data, int &Compare)
{
    AnsiString opis1=UsunNawiasyKwadratoweZPoczatkuLancucha(Node1->Text);
    AnsiString opis2=UsunNawiasyKwadratoweZPoczatkuLancucha(Node2->Text);
    //ShowMessage(opis1+"    "+opis2);
    Compare=opis1.AnsiCompareIC(opis2);
}
//---------------------------------------------------------------------------

//odwiezanie listy na bazie danych z wzw (bez ustalania listy okien)
void __fastcall TForm1::CheckBox4Click(TObject *Sender)
{
    ElementyOpisu elementyOpisu;
    elementyOpisu.uchwyt=CheckBox4->Checked;
    elementyOpisu.tytulOkna=CheckBox5->Checked;
    elementyOpisu.nazwaKlasyOkna=CheckBox6->Checked;
    elementyOpisu.wlascicielProcesu=CheckBox7->Checked;

    for(int i=0;i<TreeView1->Items->Count;++i)
    {
        DaneOkna* pDaneOkna = (DaneOkna*)(TreeView1->Items->Item[i]->Data);
        AnsiString opisWezla;
        if(elementyOpisu.uchwyt) opisWezla+="["+(AnsiString)(int)pDaneOkna->uchwyt+"] ";
        if(elementyOpisu.tytulOkna) opisWezla+=(AnsiString)pDaneOkna->tytul+" ";
        if(elementyOpisu.nazwaKlasyOkna) opisWezla+="("+(AnsiString)pDaneOkna->nazwaKlasy+") ";
        if(elementyOpisu.wlascicielProcesu) opisWezla+=(AnsiString)"{"+pDaneOkna->loginWlascicielaProcesu+"}";
        opisWezla=opisWezla.Trim();
        TreeView1->Items->Item[i]->Text=opisWezla;
    }
}
//---------------------------------------------------------------------------

void TForm1::ZapelnijTabele()
{
    //naglowek
    //StringGrid1->RowHeights[0]=2*Label1->Height;
    StringGrid1->Cells[0][0]="Tytu";
    StringGrid1->Cells[1][0]="Uchwyt";
    StringGrid1->Cells[2][0]="Nazwa klasy";
    StringGrid1->Cells[3][0]="Waciciel";
    StringGrid1->Cells[4][0]="Gwne";
    StringGrid1->Cells[5][0]="Pooenie";
    StringGrid1->Cells[6][0]="Rozmiar";

    //for(int i=0;i<StringGrid1->ColCount;i++) StringGrid1->ColWidths[i]=StringGrid1->ClientWidth/StringGrid1->ColCount;
    StringGrid1->ColWidths[0]=0.25*StringGrid1->ClientWidth;
    StringGrid1->ColWidths[1]=0.15*StringGrid1->ClientWidth;
    StringGrid1->ColWidths[2]=0.2*StringGrid1->ClientWidth;
    StringGrid1->ColWidths[3]=0.1*StringGrid1->ClientWidth;
    StringGrid1->ColWidths[4]=0.1*StringGrid1->ClientWidth;
    StringGrid1->ColWidths[5]=0.1*StringGrid1->ClientWidth;
    StringGrid1->ColWidths[6]=0.09*StringGrid1->ClientWidth;

    //StringGrid1->RowCount=TreeView1->Items->Item[0]->Count;
    StringGrid1->RowCount=TreeView1->Items->Count+1;

    for(int i=0;i<TreeView1->Items->Count;++i)
    {
        DaneOkna* pDaneOkna = (DaneOkna*)(TreeView1->Items->Item[i]->Data);
        StringGrid1->Cells[0][i+1]=pDaneOkna->tytul;
        StringGrid1->Cells[1][i+1]=(AnsiString)(int)pDaneOkna->uchwyt;
        StringGrid1->Cells[2][i+1]=pDaneOkna->nazwaKlasy;
        StringGrid1->Cells[3][i+1]=pDaneOkna->loginWlascicielaProcesu;
        StringGrid1->Cells[4][i+1]=pDaneOkna->czyOknoGlowne?"tak":"nie";
        StringGrid1->Cells[5][i+1]=(AnsiString)(int)pDaneOkna->polozenie.left+","+(AnsiString)(int)pDaneOkna->polozenie.top;
        StringGrid1->Cells[6][i+1]=(AnsiString)(int)(pDaneOkna->polozenie.right-pDaneOkna->polozenie.left)+","+(AnsiString)(int)(pDaneOkna->polozenie.bottom-pDaneOkna->polozenie.top);
    }
}

void TForm1::RysujRamke(TCanvas* plotno,RECT polozenie,TColor kolor,int szerokosc,char* opis)
{
    plotno->Pen->Color=kolor;
    plotno->Pen->Width=szerokosc;
    plotno->Brush->Color = clWhite;
    plotno->Font->Size=10;
    plotno->Font->Color=kolor;
    plotno->TextOut(polozenie.left+2*szerokosc,polozenie.top+2*szerokosc,opis);
    /*
    plotno->MoveTo(polozenie.left+szerokosc/2,polozenie.top+szerokosc/2);
    plotno->LineTo(polozenie.left+szerokosc/2,polozenie.bottom-szerokosc/2);
    plotno->LineTo(polozenie.right-szerokosc/2,polozenie.bottom-szerokosc/2);
    plotno->LineTo(polozenie.right-szerokosc/2,polozenie.top+szerokosc/2);
    plotno->LineTo(polozenie.left+szerokosc/2,polozenie.top+szerokosc/2);
    */
    plotno->Rectangle(polozenie.left+szerokosc/2,polozenie.top+szerokosc/2,polozenie.right-szerokosc/2,polozenie.bottom-szerokosc/2);
}

//wybor okna w liscie na lewym panelu
void __fastcall TForm1::TreeView1Change(TObject *Sender, TTreeNode *Node)
{
    int indeks=Node->AbsoluteIndex;
    StringGrid1->Row=indeks+1;

    DaneOkna* pDaneOkna = (DaneOkna*)(Node->Data);
    if(pDaneOkna!=NULL)
    {
        Label8->Caption=pDaneOkna->tytul;
        Label10->Caption=(AnsiString)(int)pDaneOkna->uchwyt;
        Label9->Caption=pDaneOkna->nazwaKlasy;
        Label13->Caption=pDaneOkna->loginWlascicielaProcesu;
        Label15->Caption=pDaneOkna->czyOknoGlowne?"tak":"nie";
        Label11->Caption=(AnsiString)(int)pDaneOkna->polozenie.left+","+(AnsiString)(int)pDaneOkna->polozenie.top;
        Label12->Caption=(AnsiString)(int)(pDaneOkna->polozenie.right-pDaneOkna->polozenie.left)+","+(AnsiString)(int)(pDaneOkna->polozenie.bottom-pDaneOkna->polozenie.top);

        Image2->Picture->Bitmap->Canvas->Brush->Color=clWhite;
        Image2->Picture->Bitmap->Canvas->FillRect(Rect(0,0,Image2->Picture->Bitmap->Width,Image2->Picture->Bitmap->Height));
        //RysujRamke(Image2->Picture->Bitmap->Canvas,pDaneOkna->polozenie,clRed,5,pDaneOkna->tytul);
        RysujRamke(Image2->Picture->Bitmap->Canvas,pDaneOkna->polozenie,clRed,8,"");
    }
}

//---------------------------------------------------------------------------

void __fastcall TForm1::FormShow(TObject *Sender)
{
    TreeView1->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)
{
    Close();
}
//---------------------------------------------------------------------------


void __fastcall TForm1::StringGrid1SelectCell(TObject *Sender, int ACol,
      int ARow, bool &CanSelect)
{
    TreeView1->Selected=TreeView1->Items->Item[ARow-1];
    TreeView1->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button4Click(TObject *Sender)
{
    DaneOkna* pDaneOkna = (DaneOkna*)(TreeView1->Selected->Data);
    char nowyTytulOkna[256];
    strcpy(nowyTytulOkna,pDaneOkna->tytul);
    strcat(nowyTytulOkna," [");
    char bufor[256]; itoa((int)pDaneOkna->uchwyt,bufor,10);
    strcat(nowyTytulOkna,bufor);
    strcat(nowyTytulOkna,"]");
    SetWindowText(pDaneOkna->uchwyt,nowyTytulOkna);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button6Click(TObject *Sender)
{
    DaneOkna* pDaneOkna = (DaneOkna*)(TreeView1->Selected->Data);
    ShowWindow(pDaneOkna->uchwyt,SW_NORMAL);
    BringWindowToTop(pDaneOkna->uchwyt);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button5Click(TObject *Sender)
{
    DaneOkna* pDaneOkna = (DaneOkna*)(TreeView1->Selected->Data);
    //DestroyWindow(pDaneOkna->uchwyt);
    SendMessage(pDaneOkna->uchwyt,WM_CLOSE,NULL,NULL);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button7Click(TObject *Sender)
{
    //odswiezanie listy
    Button1Click(NULL);
    TreeView1->Refresh();

    //przebiega wezly
    TreeView1->Items->BeginUpdate();
    TTreeNode* wezel=TreeView1->Items->GetFirstNode();
    while(wezel!=NULL)
    {
        DaneOkna* pDaneOkna = (DaneOkna*)(wezel->Data);
        HWND uchwytOkna = pDaneOkna->uchwyt;
        if(IsWindowVisible(uchwytOkna) && pDaneOkna->czyOknoGlowne)
        {
            ShowWindowAsync(uchwytOkna,SW_SHOWMINIMIZED);
        }
        wezel=wezel->GetNext();
    }
    TreeView1->Items->EndUpdate();
}
//---------------------------------------------------------------------------

#include <shldisp.h>

void __fastcall TForm1::Button8Click(TObject *Sender)
{
    //Shell32.ShellClass objShel = new Shell32.ShellClass(); //Tworzy instancje klasy powoki (shell class)
    //((Shell32.IShellDispatch4) objShel).ToggleDesktop(); //Poka pulpit/poka okna

    //Inicjacja COM
    CoInitialize(NULL);

    //Tworzy instancj klasy powoki (shell class)
    IShellDispatch4 *pShellObj = NULL;
    CoCreateInstance( CLSID_Shell, NULL, CLSCTX_SERVER, IID_IDispatch, (LPVOID *) &pShellObj );

    //Poka pulpit
    pShellObj->ToggleDesktop();

    //Zwolnienie obiektu
    pShellObj->Release();
}
//---------------------------------------------------------------------------

