//---------------------------------------------------------------------------

#pragma hdrstop

#include "Okno.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

#define MAINICON 101

bool TOkno::Init(HINSTANCE uchwytAplikacji,WNDPROC procesuraOkna,POINT polozenieOkna,POINT rozmiarOkna)
{
	char nazwaOkna[]="Aplikacja Win32";

	WNDCLASSEX wc;
	wc.cbSize=sizeof(wc);
	wc.style= CS_HREDRAW | CS_VREDRAW | CS_OWNDC; //styl okna
	//wc.lpfnWndProc= (WNDPROC)::WndProc; //procedura okna
    wc.lpfnWndProc= procesuraOkna;
	wc.cbClsExtra= 0; //dodatkowe bajty zarezerwowane za klas okna
	wc.cbWndExtra= 0; //dodatkowe bajty zarezerwowane za instancj okna
	wc.hInstance= uchwytAplikacji; //instancja aplikacji
	wc.hIcon= LoadIcon(uchwytAplikacji,MAKEINTRESOURCE(MAINICON)); //uchwyt ikony
	wc.hIconSm= LoadIcon(uchwytAplikacji,MAKEINTRESOURCE(MAINICON)); //uchwyt ikony
	wc.hCursor= LoadCursor(NULL, IDC_ARROW); //uchwyt kursora
	wc.hbrBackground= (HBRUSH)(COLOR_WINDOW+1); //uchwyt pdzla ta
	wc.lpszMenuName= NULL; //nazwa menu
	wc.lpszClassName= nazwaOkna; //nazwa klasy okna

	//Rejestracja klasy okna
	if(RegisterClassEx(&wc)==0) return false;

	bool trybPelnoekranowy=false;

	//ustawienia dla okna
	DWORD stylOkna=WS_OVERLAPPEDWINDOW;

	if (trybPelnoekranowy)
	{
		//ustawienia dla trybu pelnoekranowego
		polozenieOkna.x=0;
		polozenieOkna.y=0;
		//rozmiarOkna.x=1024;
		//rozmiarOkna.y=768;
		RECT rozmiarEkranu;
		GetWindowRect(GetDesktopWindow(),&rozmiarEkranu);
		rozmiarOkna.x=rozmiarEkranu.right-rozmiarEkranu.left;
		rozmiarOkna.y=rozmiarEkranu.bottom-rozmiarEkranu.top;
		stylOkna=WS_POPUP;
		if (!ZmianaRozdzielczosci(rozmiarOkna.x,rozmiarOkna.y)) return false;
	}

	//Tworzenie okna
	uchwytOkna = CreateWindow(
		nazwaOkna, //nazwa klasy okna
		nazwaOkna, //nazwa okna
		stylOkna,
		polozenieOkna.x,polozenieOkna.y, //pooenie okna (x,y)
		rozmiarOkna.x,rozmiarOkna.y, //rozmiar okna (szeroko, wysoko)
		NULL, //uchwyt okna nadrzdnego (parent)
		NULL, //uchwyt menu
		uchwytAplikacji, //uchwyt instancji aplikacji
		NULL //parametr komunikatu informujacego o utworzeniu okna
	);

	if(uchwytOkna==NULL) return false;

	//Pokazanie i aktualizacja okna
	ShowWindow(uchwytOkna,SW_SHOW);
	UpdateWindow(uchwytOkna);

	return true;
};

WPARAM TOkno::Run()
{
	//Petla glowna - obsluga komunikatow
	MSG msg;
	while(GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

LRESULT TOkno::WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam)
{
	switch (message)
	{
		case WM_DESTROY: //Zamykanie okna => konczenie aplikacji
			//ChangeDisplaySettings(NULL,0); //przywrocenie domyslnej rozdzielczosci ekranu
			PostQuitMessage(0);
			break;
		case WM_SIZE: //Zmiana rozmiaru okna
			RECT rect;
			GetClientRect(hWnd, &rect);
			szerokoscObszaruUzytkownika = rect.right - rect.left;
			wysokoscObszaruUzytkownika = rect.bottom - rect.top;
            ::Beep(100,10);
			break;
		default: //Automatyczne przetwarzanie komunikatow
			return (DefWindowProc(hWnd, message, wParam, lParam));
	}

	return 0L;
}

bool TOkno::ZmianaRozdzielczosci(long szerokosc,long wysokosc,long glebiaKolorow) const
{
	DEVMODE dmScreenSettings;	//struktura trybu wyswietlania
	memset(&dmScreenSettings,0,sizeof(dmScreenSettings));	//czyszczenie pamieci
	dmScreenSettings.dmSize=sizeof(dmScreenSettings);		//rozmiar struktury
	dmScreenSettings.dmPelsWidth	= szerokosc;			//nowa szerokosc ekranu
	dmScreenSettings.dmPelsHeight	= wysokosc;				//nowa wysokosc ekranu
	dmScreenSettings.dmBitsPerPel	= glebiaKolorow;		//ilosc bitow opisujacych kolor piksela
	dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;
	return ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)==DISP_CHANGE_SUCCESSFUL;
}
