unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Complex;

  //W Delphi jest biblioteka VarCmplx oparta na Variant

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
    zbiorMandelbrotLubJulia :Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  Randomize;
  zbiorMandelbrotLubJulia:=Random(100)>50;
end;

procedure TForm1.FormPaint(Sender: TObject);
var
  zero :TComplex;
  stalaJulia :TComplex;
  w,h :Integer;
  x,y :Integer;

  //dywan
  //r,g,b :Integer;
  //Kolor :TColor;

  //Mandelbrot
  min,max :TComplex;
  z,c :TComplex;
  indeks :Byte;
begin
  zero:=TComplex.Zero; //zmienic na const?
  stalaJulia:=TComplex.Create(0.25,0.55);

  Self.Cursor:=crHourGlass;

  w:=Self.ClientWidth;
  h:=Self.ClientHeight;

  {
  //Dywan
  Self.Caption:='Dywan';

  for x:=0 to w do
    for y:=0 to h do
    begin
      r:=Round(255.0*sin((x-y)/100.0));
      g:=Round(255.0*cos((x+y)/100.0));
      b:=0;
      Kolor:=RGB(r,g,b);
      Canvas.Pixels[x,y]:=Kolor;
    end;
  }

  //Mandelbrot/Julia z wlasnymi complex
  //Mandelbrot/Julia z VarCmplx
  if zbiorMandelbrotLubJulia then Self.Caption:='Zbir Mandelbrota'
  else Self.Caption:='Zbir Julii';

	//zakres domyslny
	min:=TComplex.Create(-2.2,-1.2); //min,max - zakres badanej plaszczyzny zespolonej
	max:=TComplex.Create(1.2,1.2);
    //zakres: spirala w zbiorze Mandelbrota
	//fcomplex min(0.2016,0.541); //min,max - zakres badanej plaszczyzny zespolonej
	//fcomplex max(0.2175,0.5521);

  z:=TComplex.Zero;
  c:=TComplex.Zero;

  for x:=0 to w do //x,y - wspolrzedne pikseli
	  for y:=0 to h do
		  begin
			  if zbiorMandelbrotLubJulia then
			    begin
			    //Mandelbrot
          c.SetValue(x*(Real(max)-Real(min))/w,y*(Imag(max)-Imag(min))/h);
          c.Dodaj(min);
          //c:=ComplexSuma(min,tmp); //wyciek pamieci
				  z.SetValue(zero);
          end
        else
			    begin
			    //Julia
          z.SetValue(x*(Real(max)-Real(min))/w,y*(Imag(max)-Imag(min))/h);
          z.Dodaj(min);
          //z:=ComplexSuma(min,tmp); //wyciek pamieci
				  c.SetValue(stalaJulia);
          end;

        indeks:=0;
        while(indeks<255) do
          begin
            //z:=ComplexSuma(ComplexIloczyn(z,z),c); //masywny wyciek pamieci
            z.Pomnoz(z); z.Dodaj(c);
		        if (z.Norm>=4) then Break;
            Inc(indeks);
          end;
        //Caption:=ComplexToStr(z);
        //Caption:=IntToStr(x)+' '+IntToStr(y);

    if indeks=255 then Canvas.Pixels[x,y]:=clBlack
    //else Canvas.Pixels[x,y]:=clWhite;
    else Canvas.Pixels[x,y]:=RGB(255-indeks,255-indeks,255-indeks);
  end;

  Self.Cursor:=crDefault;

  zero.Destroy;
  stalaJulia.Destroy;
  min.Destroy;
  max.Destroy;
  z.Destroy;
  c.Destroy;
end;

end.
