#include <vcl.h>
#include <conio.h>
#pragma hdrstop
#include "windows.h"
#include <commctrl.h>
#include <commdlg.h>
#pragma package(smart_init)
#pragma resource "*.dfm"
#include <iostream>
#include <iomanip>
#include <sstream>
#include <vector>
#include <string>
using namespace std;
#include "Unit1.h"
#include "Unit2.h"
#include "Info.h"
//---------------------------------------------------------------------------
//Some required stuff
TForm1 *Form1;
VolumeManagement x;

bool AllowDelete = true,
     AllowRename = true,
     Renamable = false;

Info* inf;

struct ww
{
  TTreeNode* Node;
  int j;
};

//Threads
HANDLE semaphore;
CRITICAL_SECTION m_cs;
//DWORD WINAPI TForm1::Watek()
void WINAPI TForm1::Watek()
{
  RefreshExecute(NULL);
}

DWORD WINAPI TForm1::WatekProc(void* Klasa)
{
  EnterCriticalSection(&m_cs);
  Form1->RefreshExecute(NULL);
  LeaveCriticalSection(&m_cs);
  return 0;
}

void TForm1::Watek_ON()
{
  Thread = CreateThread(NULL, 0, WatekProc, NULL, 0, &ThreadID);
  SuspendThread(Thread);
  SetPriorityClass(Thread, REALTIME_PRIORITY_CLASS);
  SetThreadPriority(Thread, THREAD_PRIORITY_TIME_CRITICAL);
  ResumeThread(Thread);
}

DWORD WINAPI TForm1::WatekProc2(void* cos)
{
  Form1->Action1Execute((TObject*)cos);
  return 0;
}

void TForm1::Watek_ON2(void* cos)
{
  Thread2 = CreateThread(NULL, 0, WatekProc2, cos, 0, &ThreadID2);
  SuspendThread(Thread2);
  SetPriorityClass(Thread2, REALTIME_PRIORITY_CLASS);
  SetThreadPriority(Thread2, THREAD_PRIORITY_NORMAL);
  ResumeThread(Thread2);
}
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
  InitializeCriticalSection(&m_cs);
  //Setup Controls
  TreeView->AutoExpand = false;
  TreeView->Images = ImageList1;

  Watek_ON();
}

//---------------------------------------------------------------------------
//DONE
void __fastcall TForm1::TreeViewChange(TObject *Sender, TTreeNode *Node)
{
  //TTreeNode* Node = TreeView->Selected;
  if(TreeView->Selected->Data != NULL)
  {
    //Getting Filetime information starts here
    PWIN32_FIND_DATA TempFindData = PWIN32_FIND_DATA(TreeView->Selected->Data);

    SYSTEMTIME System_CreationTime,
           System_LastAccessTime,
           System_LastWriteTime;

    //Converting FILETIME structure to SYSTEMTIME
    FileTimeToSystemTime(&TempFindData->ftCreationTime, &System_CreationTime);
    FileTimeToSystemTime(&TempFindData->ftLastAccessTime, &System_LastAccessTime);
    FileTimeToSystemTime(&TempFindData->ftLastWriteTime, &System_LastWriteTime);

    ostringstream CreationTime,
                  LastAccessTime,
                  LastWriteTime,
                  FileSize;

    //Standard labels
    Label1->Caption = "Filename:";
    Label2->Caption = "Creation Time";
    Label3->Caption = "Last Access Time";
    Label4->Caption = "Last Write Time";
    Label5->Caption = "File Size";
    Label6->Caption = "Alternative filename:";

    //Setup all attributes
    CheckBox1->Caption  = "FILE_ATTRIBUTE_ARCHIVE";
    CheckBox2->Caption  = "FILE_ATTRIBUTE_COMPRESSED";
    CheckBox3->Caption  = "FILE_ATTRIBUTE_DEVICE";
    CheckBox4->Caption  = "FILE_ATTRIBUTE_DIRECTORY";
    CheckBox5->Caption  = "FILE_ATTRIBUTE_ENCRYPTED";
    CheckBox6->Caption  = "FILE_ATTRIBUTE_HIDDEN";
    CheckBox7->Caption  = "FILE_ATTRIBUTE_NORMAL";
    CheckBox8->Caption  = "FILE_ATTRIBUTE_NOT_CONTENT_INDEXED";
    CheckBox9->Caption  = "FILE_ATTRIBUTE_OFFLINE";
    CheckBox10->Caption = "FILE_ATTRIBUTE_READONLY";
    CheckBox11->Caption = "FILE_ATTRIBUTE_REPARSE_POINT";
    CheckBox12->Caption = "FILE_ATTRIBUTE_SPARSE_FILE";
    CheckBox13->Caption = "FILE_ATTRIBUTE_SYSTEM";
    CheckBox14->Visible = true;

    //Hdd info connected
    Label7->Visible = false;
    Label8->Visible = false;
    Label9->Visible = false;

    Edit2->Visible = false;
    Edit3->Visible = false;
    Edit4->Visible = false;
    //If node is a folder
    if(TempFindData->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
    {
      //Change some captions and make visible / unvisible stuff
      Label1->Caption = "Folder name:";
      Label6->Caption = "Alternative folder name:";

      Label1->Visible = true;
      Label2->Visible = true;
      Label3->Visible = true;
      Label4->Visible = true;
      Label5->Visible = false;
      Label6->Visible = true;

      EditAlternativeFilename->Visible = true;
      EditCreationTime->Visible        = true;
      EditFilename->Visible            = true;
      EditFileSize->Visible            = false;
      EditLastAccessTime->Visible      = true;
      EditLastWriteTime->Visible       = true;

      //If it's first time open add childs
      if(TreeView->Selected->HasChildren && TreeView->Selected->getFirstChild() == NULL)
      {
        Watek_ON2(NULL);
        WIN32_FIND_DATA* FindFileData = new WIN32_FIND_DATA;
        FindFirstFile(Info::PathBuilder(TreeView->Selected).c_str(), FindFileData);
      }
    }
    //if not folder then have to be a file
    else
    {
      Label1->Visible = true;
      Label2->Visible = true;
      Label3->Visible = true;
      Label4->Visible = true;
      Label5->Visible = true;
      Label6->Visible = true;

      EditAlternativeFilename->Visible = true;
      EditCreationTime->Visible      = true;
      EditFilename->Visible        = true;
      EditFileSize->Visible        = true;
      EditLastAccessTime->Visible    = true;
      EditLastWriteTime->Visible      = true;
    }
    //Building strings containing info about data
    CreationTime << System_CreationTime.wYear << "-";
    CreationTime << setfill ('0') << setw(2) << System_CreationTime.wMonth <<"-";
    CreationTime << setfill ('0') << setw(2) << System_CreationTime.wDay << " ";
    CreationTime << setfill ('0') << setw(2) << System_CreationTime.wHour << ":";
    CreationTime << setfill ('0') << setw(2) << System_CreationTime.wMinute << ":";
    CreationTime << setfill ('0') << setw(2) << System_CreationTime.wSecond;

    LastAccessTime << System_LastAccessTime.wYear << "-";
    LastAccessTime << setfill ('0') << setw(2) << System_LastAccessTime.wMonth << "-";
    LastAccessTime << setfill ('0') << setw(2) << System_LastAccessTime.wDay << " ";
    LastAccessTime << setfill ('0') << setw(2) << System_LastAccessTime.wHour << ":";
    LastAccessTime << setfill ('0') << setw(2) << System_LastAccessTime.wMinute << ":";
    LastAccessTime << setfill ('0') << setw(2) << System_LastAccessTime.wSecond;

    LastWriteTime << setfill ('0') << setw(2) << System_LastWriteTime.wYear << "-";
    LastWriteTime << setfill ('0') << setw(2) << System_LastWriteTime.wMonth << "-";
    LastWriteTime << setfill ('0') << setw(2) << System_LastWriteTime.wDay << " ";
    LastWriteTime << setfill ('0') << setw(2) << System_LastWriteTime.wHour << ":";
    LastWriteTime << setfill ('0') << setw(2) << System_LastWriteTime.wMinute << ":";
    LastWriteTime << setfill ('0') << setw(2) << System_LastWriteTime.wSecond;
    //End of getting filetime information

    EditFilename->Text = TempFindData->cFileName;
    EditAlternativeFilename->Text = TempFindData->cAlternateFileName;
    if(EditAlternativeFilename->Text.Length() != 8)
    {
      EditAlternativeFilename->Visible = false;
      Label6->Visible = false;
    }
    EditCreationTime->Text = CreationTime.str().c_str();
    EditLastAccessTime->Text = LastAccessTime.str().c_str();
    EditLastWriteTime->Text = LastWriteTime.str().c_str();


    Double Size = TempFindData->nFileSizeHigh*(MAXDWORD+1)+TempFindData->nFileSizeLow;
    int i=0;
    while(Size>1024)
    {
      Size /= 1024;
      i++;
    }
    string suffix[] = { "B", "KB", "MB", "GB" };
    FileSize << setprecision(2) << fixed << Size << " " << suffix[i];
    EditFileSize->Text = FileSize.str().c_str();

    ChooseFlagsExecute((TObject*)TempFindData->dwFileAttributes);
  }
  else
  {
    //If no parent then have to be a drive
    if(!TreeView->Selected->Parent)
    {
      //Setup all attributes
      CheckBox1->Caption  = "FILE_NAMED_STREAMS";
      CheckBox2->Caption  = "FILE_READ_ONLY_VOLUME";
      CheckBox3->Caption  = "FILE_SUPPORTS_OBJECT_IDS";
      CheckBox4->Caption  = "FILE_SUPPORTS_REPARSE_POINTS";
      CheckBox5->Caption  = "FILE_SUPPORTS_SPARSE_FILES";
      CheckBox6->Caption  = "FILE_VOLUME_QUOTAS";
      CheckBox7->Caption  = "FS_CASE_IS_PRESERVED";
      CheckBox8->Caption  = "FS_CASE_SENSITIVE";
      CheckBox9->Caption  = "FS_FILE_COMPRESSION";
      CheckBox10->Caption = "FS_FILE_ENCRYPTION";
      CheckBox11->Caption = "FS_PERSISTENT_ACLS";
      CheckBox12->Caption = "FS_UNICODE_STORED_ON_DISK";
      CheckBox13->Caption = "FS_VOL_IS_COMPRESSED";
      CheckBox14->Visible = false;

      //Hdd info connected
      Label7->Visible = true;
      Label8->Visible = true;
      Label9->Visible = true;

      Edit2->Visible = true;
      Edit3->Visible = true;
      Edit4->Visible = true;

      unsigned char FileSystem[MAX_PATH],
              VolumeName[MAX_PATH];
      unsigned long Serial,
              MaxFileLength,
              SystemFlags;

      bool check = GetVolumeInformation(TreeView->Selected->Text.c_str(),
                       (LPTSTR)VolumeName,
                       MAX_PATH,
                       &Serial,
                       &MaxFileLength,
                       &SystemFlags,
                       (LPTSTR)FileSystem,
                       MAX_PATH);

      //If not an empty dvd/cd etc drive
      if(GetLastError() != ERROR_NOT_READY && check)
      {
        Label1->Visible = true;
        Label2->Visible = true;
        Label3->Visible = true;
        Label4->Visible = true;
        EditFilename->Visible = true;
        EditCreationTime->Visible = true;
        EditLastAccessTime->Visible = true;
        EditLastWriteTime->Visible = true;

        ostringstream output1, output2;
        output1 << VolumeName;
        output2 << FileSystem;
        EditFilename->Text = output1.str().c_str();
        EditCreationTime->Text = Serial;
        EditLastAccessTime->Text = output2.str().c_str();

        unsigned __int64* sizes = Info::GetHddSizes(Node->Text.c_str());

        vector<TEdit*> v;
        v.push_back(Edit2);
        v.push_back(Edit3);
        v.push_back(Edit4);

        string suffix[] = { "B", "KB", "MB", "GB", "TB" };
        for(unsigned int i=0; i<v.size(); i++)
        {
          int j=0;
          long double value = sizes[i];
          ostringstream stream;
          while(value>1024)
          {
            value /= 1024;
            j++;
          }
          stream << setprecision(2) << fixed << value << " " << suffix[j];
          v[i]->Text = stream.str().c_str();
        }
      }
      else
      {
        Label1->Visible = false;
        Label2->Visible = false;
        Label3->Visible = false;
        Label4->Visible = true;
        EditFilename->Visible = false;
        EditCreationTime->Visible = false;
        EditLastAccessTime->Visible = false;
        EditLastWriteTime->Visible = true;

        //Hdd info connected
        Label7->Visible = false;
        Label8->Visible = false;
        Label9->Visible = false;

        Edit2->Visible = false;
        Edit3->Visible = false;
        Edit4->Visible = false;
      }
      Label1->Caption = "Drive Name:";
      Label2->Caption = "Serial:";
      Label3->Caption = "File system:";
      Label4->Caption = "Drive type:";
      Label5->Visible = false;
      Label6->Visible = false;
      EditFileSize->Visible = false;
      EditAlternativeFilename->Visible = false;
      EditLastWriteTime->Text = x.GetDriveType_(TreeView->Selected->Text.c_str()).c_str();
      ChooseFlagsExecute((TObject*)SystemFlags);
    }
  }
  TreeView->Selected = TreeView->Selected;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TreeViewCompare(TObject *Sender, TTreeNode *Node1,
      TTreeNode *Node2, int Data, int &Compare)
{
  if(Node1->ImageIndex != 3 && Node2->ImageIndex == 3)
    Compare = 1;
  else if(Node1->ImageIndex == 3 && Node2->ImageIndex == 3)
    Compare = 0;
  else
    Compare = -1;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::AllowDelete1Click(TObject *Sender)
{
  if(AllowDelete1->Checked)
  {
    Delete1->Enabled = false;
    Delete2->Enabled = false;
    AllowDelete = false;
    AllowDelete1->Checked = false;
  }
  else
  {
    AllowDelete1->Checked = true;
    Delete1->Enabled = true;
    Delete2->Enabled = true;
    AllowDelete = true;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::AllowRename1Click(TObject *Sender)
{
  if(AllowRename1->Checked)
  {
    AllowRename1->Checked = false;
    Rename1->Enabled = false;
    Rename2->Enabled = false;
    Delete1->Enabled = false;
    AllowRename = false;
  }
  else
  {
    AllowRename1->Checked = true;
    Rename1->Enabled = true;
    Rename2->Enabled = true;
    AllowRename = true;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::File1Click(TObject *Sender)
{
  TTreeNode* Node = TreeView->Selected;
  if(!Node)
    Node = TreeView->Items->GetFirstNode();

  bool Changeable = false;
  if(Node)
  {
    Changeable = Info::Changeable(Node->Data);
    Properties2->Enabled = true;
  }
  else
    Properties2->Enabled = false;
  Copy1->Enabled = Changeable;
  Move1->Enabled = Changeable;
  Edit1->Enabled = Changeable;
  if(Renamable)
  {
    Rename1->Enabled = true;
    Rename2->Enabled = true;
  }
  else
  {
    Rename1->Enabled = false;
    Rename2->Enabled = false;
  }
  if(AllowDelete)
  {
    Delete1->Enabled = Changeable;
    Delete2->Enabled = Changeable;
  }
  else
  {
    Delete1->Enabled = false;
    Delete2->Enabled = false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PopupMenu1Popup(TObject *Sender)
{
  TreeView->Selected = TreeView->Selected;
  bool Changeable = Info::Changeable(TreeView->Selected->Data);
  Copy1->Enabled = Changeable;
  Move1->Enabled = Changeable;
  Edit1->Enabled = Changeable;

  if(AllowRename)
  {
    Rename1->Enabled = Renamable;
    Rename2->Enabled = Renamable;
  }
  else
  {
    Rename1->Enabled = false;
    Rename2->Enabled = false;
  }
  if(AllowDelete)
  {
    Delete1->Enabled = Changeable;
    Delete2->Enabled = Changeable;
  }
  else
  {
    Delete1->Enabled = false;
    Delete2->Enabled = false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Rename1Click(TObject *Sender)
{
  if(TreeView->Selected->Data)
    TreeView->Selected->EditText();
  else if (Application->MessageBox("Are you sure to rename this volume?",
        "Renaming Volume",
        MB_YESNO | MB_ICONWARNING) == IDYES)
  {
    if(CheckBox2->State == cbChecked)
    {
      StatusBar->SimpleText = "Not possible to rename readonly drive";
      return;
    }
    string name = InputBox("Input new name",
                           "Enter the label for volume",
                           "").c_str();
    if(name.size() > 0)
    {
      if(SetVolumeLabel(TreeView->Selected->Text.c_str(), name.c_str()))
      {
        AnsiString out;
        out = "Volume " + TreeView->Selected->Text + " label changed to: ";
        StatusBar->SimpleText = out + name.c_str();
        EditFilename->Text = name.c_str();
      }
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TreeViewEdited(TObject *Sender, TTreeNode *Node,
      AnsiString &S)
{
  if(S.Length() < 260)
  {
    AnsiString to, from = Info::PathBuilder(Node->Parent);
    to = from;
    from += Node->Text;
    to += S;
    if(MoveFile(from.c_str(), to.c_str()))
    {
      WIN32_FIND_DATA* TempFindData = new WIN32_FIND_DATA;
      HANDLE file = FindFirstFile(to.c_str(), TempFindData);

                        if(file != INVALID_HANDLE_VALUE)
                        {
              Node->Data = TempFindData;
              TreeViewChange(this, Node);
              StatusBar->SimpleText = "Object name was changed";
                        }
                        else
                                StatusBar->SimpleText = "Invalid file, couldn't rename. Please Try again.";
    }
    else
    {
      StatusBar->SimpleText = "Couldn't rename selected item";
      S = Node->Text;
    }
  }
  else
    StatusBar->SimpleText = "Name of the object have to be less than 260 chars";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TreeViewEditing(TObject *Sender, TTreeNode *Node,
      bool &AllowEdit)
{
  if(!Node->Parent)
    AllowEdit = false;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Copy1Click(TObject *Sender)
{
  if(TreeView->Selected->Data)
  {
    SaveDialog1->FileName = TreeView->Selected->Text;
    if(SaveDialog1->Execute())
    {
      string destination = SaveDialog1->FileName.c_str();
      if(destination.length() > 3)
      {
        //Building searchstring;
        AnsiString from = Info::PathBuilder(TreeView->Selected->Parent);
        from += TreeView->Selected->Text;
        if(Info::Operation(FO_COPY, from, destination.c_str()))
          StatusBar->SimpleText = "Object was copyied";
        else
          StatusBar->SimpleText = "Couldn't copy object, maybe the path already exists or is wrong";
      }
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Move1Click(TObject *Sender)
{
  if(TreeView->Selected->Data)
  {
    SaveDialog1->FileName = TreeView->Selected->Text;
    if(SaveDialog1->Execute())
    {
      string destination = SaveDialog1->FileName.c_str();
      if(destination.length() > 3)
      {
        //Building searchstring;
        AnsiString from = Info::PathBuilder(TreeView->Selected->Parent);
        from += TreeView->Selected->Text;
        if(Info::Operation(FO_MOVE, from, destination.c_str()))
        {
          TreeView->Selected->Delete();
          StatusBar->SimpleText = "Object was moved";
        }
        else
          StatusBar->SimpleText = "Couldn't move object, maybe the path already exists or is wrong";
      }
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Delete1Click(TObject *Sender)
{
//That was done first so might be sort of long
  if(TreeView->Selected->Data)
  {
    //Gather data of the node
    PWIN32_FIND_DATA TempFindData = PWIN32_FIND_DATA(TreeView->Selected->Data);
    string FileOrFolder = "file";
    BOOL flag = true;
    //Check node is folder or file node
    //Could use DirectoryExists() too
    if (TempFindData->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
    {
      FileOrFolder = "folder";
      flag = false;
    }

    //Building question string obviously
    string question = "Do you want to remove " + FileOrFolder + ": ";
    question += TreeView->Selected->Text.c_str();
    question += " ?";

    //Make sure that user is sure
    string title = "Removing " + FileOrFolder;
    if (Application->MessageBox(question.c_str(),
                  title.c_str(),
                  MB_YESNO | MB_ICONWARNING) == IDYES)
    {
      //Building searchstring;
      AnsiString from = Info::PathBuilder(TreeView->Selected->Parent);
      from += TreeView->Selected->Text;

      //Output string used to display in StatusBar
      AnsiString out;

      //If File then use file functions
      if(flag == true)
      {
        //If removed then remove node and display info
        if(DeleteFile(from.c_str()))
        {
          TreeView->Selected->Delete();
          out = TempFindData->cFileName;
          StatusBar->SimpleText = out + " was removed";
        }
        //Else say it was not possible
        else
        {
          out = "Couldn't remove ";
          out += TempFindData->cFileName;
          StatusBar->SimpleText = out;
        }
      }
      //Else folder
      else
      {
        //Remove single directory (empty one)
        if(RemoveDirectory(from.c_str()) && !GetLastError())
        {
          out = TempFindData->cFileName;
          StatusBar->SimpleText = out + " was removed";
          delete[] TempFindData;
          delete[] this->TreeView->Selected->Data;
          this->TreeView->Selected->Delete();
        }
        //If failed then remove recursive
        else
        {
          //If removed then delete all unused stuff and remove node
          if(Info::Operation(FO_DELETE, from, "") && !GetLastError())
          {
            out = TempFindData->cFileName;
            StatusBar->SimpleText = out + " was removed";
            delete[] TempFindData;
            delete[] this->TreeView->Selected->Data;
            this->TreeView->Selected->Delete();
          }
          //Else show some info that wasn't possible to remove
          else
          {
            out = "Couldn't remove ";
            out += TempFindData->cFileName;
            StatusBar->SimpleText = out;
          }
        }
      }//Removing Directory End
    }//If message dialog = yes end
  }//Main removing end
  //Just in case - shouldn't be possible tho to reach this code
  else
    StatusBar->SimpleText="Cannot delete the volume";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Properties1Click(TObject *Sender)
{
  AnsiString from;
  if(this->TreeView->Selected->Parent)
  {
    //Building searchstring;
    from = inf->PathBuilder(TreeView->Selected->Parent);
    from += this->TreeView->Selected->Text;
  }
  else
    from = this->TreeView->Selected->Text;
    
  if(from.Length() > 0)
    StatusBar->SimpleText = Info::Shell(from, "properties");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Open1Click(TObject *Sender)
{
  AnsiString from;
  if(this->TreeView->Selected->Parent)
  {
    //Building searchstring;
    from = Info::PathBuilder(this->TreeView->Selected->Parent);
    from += this->TreeView->Selected->Text;
  }
  else
    from = this->TreeView->Selected->Text;
    
  if(from.Length() > 0)
    StatusBar->SimpleText = Info::Shell(from, "open");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit1Click(TObject *Sender)
{
  AnsiString from;
  if(this->TreeView->Selected->Parent)
  {
    //Building searchstring;
    from = Info::PathBuilder(this->TreeView->Selected->Parent);
    from += this->TreeView->Selected->Text;
  }
  else
    from = this->TreeView->Selected->Text;

  if(from.Length() > 0)
    StatusBar->SimpleText = Info::Shell(from, "edit");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Exit1Click(TObject *Sender)
{
  exit(EXIT_SUCCESS);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Statusbar1Click(TObject *Sender)
{
  if(Statusbar1->Checked)
  {
    Statusbar1->Checked = false;
    StatusBar->Visible = false;
  }
  else
  {
    Statusbar1->Checked = true;
    StatusBar->Visible = true;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Properties2Click(TObject *Sender)
{
  Properties1Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Rename2Click(TObject *Sender)
{
  Rename1Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Delete2Click(TObject *Sender)
{
  Delete1Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::About2Click(TObject *Sender)
{
  Form2->Visible = true;        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RefreshExecute(TObject *Sender)
{
  StatusBar->SimpleText = "";
  Timer1->Enabled = true;
  TreeView->Enabled = false;
  TreeView->Items->Clear();
  //Let's init info
  inf = new Info(TreeView, ImageList1, ProgressBar1);
  //Add all main roots
  //TTreeNode* as NULL because we don't got any
  inf->addChilds(NULL, 0);

  //Sorting main roots
  TreeView->Items->AlphaSort(false);
  TreeView->Selected = NULL;
  TreeView->AlphaSort(false);
  TreeView->Refresh();
  TreeView->Enabled = true;
  Timer1->Enabled = false;
  StatusBar->SimpleText = "Loading main nodes complete";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Refresh1Click(TObject *Sender)
{
  Watek_ON();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
  int length = StatusBar->SimpleText.Length();
  if( length > 20 || length == 0)
    StatusBar->SimpleText = "loading";
  else
    StatusBar->SimpleText = StatusBar->SimpleText + ".";
  ProgressBar1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Action1Execute(TObject *Sender)
{
  Form1->Timer1->OnTimer(NULL);
  Form1->Timer1->Enabled = true;
  inf->addChilds(TreeView->Selected, TreeView->Selected->AbsoluteIndex+1);
  Form1->Timer1->Enabled = false;
  StatusBar->SimpleText = "Loading of the folder/s is complete";
}
//---------------------------------------------------------------------------
/*
  Fills checkboxes with flags information
*/
void __fastcall TForm1::ChooseFlagsExecute(TObject *Sender)
{
  string tmp;
  int size;
  if(TreeView->Selected->Parent)
  {
    tmp = inf->getAttributes((unsigned long)Sender).c_str();
    size = tmp.length();
    if(tmp[9] == 49)
      Renamable = false;
    else
      Renamable = true;
  }
  else
  {
    tmp = x.FormatFileSystemFlags((unsigned long)Sender,"").c_str();
    size = tmp.length()-1;
    string tmp2 = EditLastWriteTime->Text.c_str();
    if(tmp2.find("DVD")!=string::npos || tmp[1]==49)
      Renamable = false;
    else
      Renamable = true;
  }
  for(int i=0; i<size; i++)
  {
    if(tmp.at(i) == 49)
    {
      TCheckBox* tcb = (TCheckBox*)GroupBox1->Controls[i];
      tcb->State = cbChecked;
    }
    else
    {
      TCheckBox* tcb = (TCheckBox*)GroupBox1->Controls[i];
      tcb->State = cbUnchecked;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Golevelup1Click(TObject *Sender)
{
  TreeView->Selected->Collapse(false);
  if(TreeView->Selected->Parent)
    TreeView->Selected = TreeView->Selected->Parent;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Refresh2Click(TObject *Sender)
{
  if(TreeView->Selected)
  {
    if(TreeView->Selected->Data)
    {
      PWIN32_FIND_DATA TempFindData = PWIN32_FIND_DATA(TreeView->Selected->Data);
      if(TempFindData->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
      {
        TreeView->Selected->DeleteChildren();
        Watek_ON2(NULL);
      }
    }
    else
    {
      TreeView->Selected->DeleteChildren();
      Watek_ON2(NULL);
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TreeViewExpanding(TObject *Sender, TTreeNode *Node,
      bool &AllowExpansion)
{
        TreeView->Selected = Node;
        //Will call "onChange" and add nodes for files
}
//---------------------------------------------------------------------------

