#include "KomunikatyOdbieranie.h"

LRESULT CALLBACK WndProcEvent(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	if(uMsg == WM_CREATE)
	{
		// Create Controls
		hGroupBox = ButtonFactory("Button", "Akcje", WS_VISIBLE | WS_CHILD | BS_GROUPBOX, 5, 5, 510, 145, hWnd, (HMENU)GB_BOX);
		hRadio_NumAndParMsg = ButtonFactory("Button", "Numery i parametry komunikatw", WS_VISIBLE | WS_CHILD | BS_AUTORADIOBUTTON, 
			15, 25, 240, 15, hWnd, (HMENU)RB_NUMANDPAR);
		hRadio_ChMsgs = ButtonFactory("Button", "Wybrane komunikaty z kolejki aplikacji", WS_VISIBLE | WS_CHILD | BS_AUTORADIOBUTTON, 
			15, 45, 240, 15, hWnd,(HMENU)RB_CHMSG);
		hRadio_HUser = ButtonFactory("Button", "Nasuchiwanie komunikatu WM_USER+1", WS_VISIBLE | WS_CHILD | BS_AUTORADIOBUTTON, 
			15, 65, 240, 15, hWnd, (HMENU)RB_HUSER);
		hRadio_MsgsLst = ButtonFactory("Button", "Lista komunikatw okna", WS_VISIBLE | WS_CHILD | BS_AUTORADIOBUTTON, 15, 85, 240, 15, hWnd, (HMENU)RB_MSGLIST);
		hRadio_NoInfo = ButtonFactory("Button", "Brak informacji", WS_VISIBLE | WS_CHILD | BS_AUTORADIOBUTTON, 15, 105, 220, 15, hWnd, (HMENU)RB_NOINFO);
		hRadio_FilesMv = ButtonFactory("Button", "Przenoszenie plikw do aplikacji", WS_VISIBLE | WS_CHILD | BS_AUTORADIOBUTTON, 15, 125, 220, 15, hWnd, (HMENU)RB_FILES);
		hCheckBox_MvSnd = ButtonFactory("Button", "Dwik przenoszenia okna (WS_MOVE)", WS_VISIBLE | WS_CHILD | BS_AUTOCHECKBOX, 260, 25, 240, 15, hWnd, (HMENU)CB_MVSND);
		hCkeckBox_SayLst = ButtonFactory("Button", "Powiadom o komunikatach do listy", WS_VISIBLE | WS_CHILD | BS_AUTOCHECKBOX, 260, 45, 240, 15, hWnd, (HMENU)CB_SAYLIST);
		hCheckBox_SSaver = ButtonFactory("Button", "Detekacja uruchomienia wygaszacza", WS_VISIBLE | WS_CHILD | BS_AUTOCHECKBOX, 260, 65, 240, 15,  hWnd, (HMENU)CB_SSAVER);
		hCheckBox_Addit = ButtonFactory("Button", "Dodatkowe pozycje w menu systemowych", WS_VISIBLE | WS_CHILD | BS_AUTOCHECKBOX, 260, 85, 250, 15, hWnd, (HMENU)CB_ADDIT);
		hAddin = ButtonFactory("Button", "", WS_VISIBLE | WS_CHILD | BS_GROUPBOX, 245, 100, 270, 50, hWnd, (HMENU)NULL);
		hLabel_HWND = ButtonFactory("Static", "Uchwyt okna:", WS_VISIBLE | WS_CHILD, 262, 121, 80, 21, hWnd, (HMENU)L_HWND);
		hStatic_HWNDNum = ButtonFactory("Edit", "", WS_VISIBLE | WS_CHILD | WS_DISABLED | ES_CENTER, 330, 122, 80, 21, hWnd, (HMENU)TF_HWNDNUM);
		hButton_Clear = ButtonFactory("Button", "Czy", WS_VISIBLE | WS_CHILD, 412, 118, 80, 21, hWnd, (HMENU)BT_CLEAR);
		hListBox = ButtonFactory(WC_LISTBOX, "", WS_VISIBLE | WS_CHILD | WS_BORDER | WS_VSCROLL, 5, 157, 510, 300, hWnd, HMENU(LB_LIST));

		// Change all controls font to system default
		ChangeControlFont(hRadio_ChMsgs);
		ChangeControlFont(hRadio_FilesMv);
		ChangeControlFont(hRadio_HUser);
		ChangeControlFont(hRadio_MsgsLst);
		ChangeControlFont(hRadio_NoInfo);
		ChangeControlFont(hRadio_NumAndParMsg);
		ChangeControlFont(hCheckBox_Addit);
		ChangeControlFont(hCheckBox_MvSnd);
		ChangeControlFont(hCheckBox_SSaver);
		ChangeControlFont(hCkeckBox_SayLst);
		ChangeControlFont(hLabel_HWND);
		ChangeControlFont(hStatic_HWNDNum);
		ChangeControlFont(hButton_Clear);
		ChangeControlFont(hGroupBox);
		ChangeControlFont(hListBox);

		// Add starting text to list box
		char* temp = new char[512];
		ZeroMemory(temp, sizeof(char)*512);
		sprintf_s(temp, sizeof(char)*512, "Uchwyt okna: %d", (int)hWnd);
		AddItem(hListBox, "Tytu okna zmieniony na 'Unikalne'");
		AddItem(hListBox, temp);
		AddItem(hListBox, "--------");

		// Add handle number to static text field
		ZeroMemory(temp, sizeof(char)*512);
		sprintf_s(temp, sizeof(char)*512, "%d", (int)hWnd);
		SetWindowText(hStatic_HWNDNum, temp);

		delete temp;

		// Set default marks -- BM_SETCHECKED doesn't work here with auto-controls
		SendMessage(hRadio_HUser, BM_CLICK, NULL, NULL);
		SendMessage(hCheckBox_MvSnd, BM_CLICK, NULL, NULL);
		SendMessage(hCheckBox_SSaver, BM_CLICK, NULL, NULL);
		SendMessage(hCheckBox_Addit, BM_CLICK, NULL, NULL);
	}
	if(uMsg == WM_DESTROY)
		PostQuitMessage(0);
	
	// ScreenSave
	if(uMsg == WM_SYSCOMMAND && wParam == SC_SCREENSAVE && SendMessage(hCheckBox_SSaver, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
		AddItem(hListBox, "Uruchomiono wygaszacz ekranu (WndProc)");

	// WM_USER+1
	if(uMsg == WM_USER+1 && SendMessage(hRadio_HUser, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
		AddItem(hListBox, "WM_USER+1 - WndProc");
	
	// Beep on window move
	if(uMsg == WM_MOVE && SendMessage(hCheckBox_MvSnd, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
	{
		FlashWindow(hWnd, true);
		Beep(1000, 10);	
	}
	
	// Window messages list
	if(SendMessage(hRadio_MsgsLst, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
	{
		if(uMsg != 308 && uMsg != WM_SETCURSOR)
		{
			char* temp = new char[512];
			sprintf_s(temp, sizeof(char)*512, "%u", uMsg);
			AddItem(hListBox, temp);
			delete temp;
		}
	}

	// Additional menu
	if(uMsg == WM_SYSCOMMAND && wParam == static_cast<int>(SE_WINDOW_INFO))
	{
		AddItem(hListBox, "Wybrana zostaa pozycja w menu aplikacji");
		MessageBox(NULL, "Aplikacja demonstrujca podstawowe techniki zwizane z komunikatami Windows (menu aplikacji)\n\nAutor: Tomasz Dzieniak\nNa podstawie projektu Sz. P. dr Jacka Matulewskiego", "Informacja", MB_OK | MB_ICONASTERISK);
	}

	// Messages on device change
	if(uMsg == WM_DEVICECHANGE)
	{
		AddItem(hListBox, "WM_DEVICECHANGE");
		switch(wParam)
		{
		case 0x8000:
			AddItem(hListBox, "Nonik woony");
			break;
		case 0x8004:
			AddItem(hListBox, "Nonik usunity");
			break;
		}
	}	

	// Button clear
	if(uMsg == WM_COMMAND && wParam == BT_CLEAR)
		SendMessage(hListBox, LB_RESETCONTENT, NULL, NULL);

	// Add user options to system menu
	if(uMsg == WM_COMMAND && HIWORD(wParam) == BN_CLICKED && LOWORD(wParam) == CB_ADDIT)
	{
		if(SendMessage(hCheckBox_Addit, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
		{if(uMsg == WM_COMMAND && HIWORD(wParam) == BN_CLICKED && LOWORD(wParam) == CB_ADDIT)
			AppendMenu(GetSystemMenu(hWnd, false), MF_SEPARATOR, 0, NULL);
			AppendMenu(GetSystemMenu(hWnd, false), MF_STRING, SE_WINDOW_INFO, "O programie...");
		}
		else
		{
			GetSystemMenu(hWnd, true);
		}
	}

	// Handle radio buttons - it's necessary to avoid files moving into app when correct radio button isn''t checked
	if(uMsg == WM_COMMAND && HIWORD(wParam) == BN_CLICKED)
	{
		switch(LOWORD(wParam))
		{
		case RB_FILES:
			if(SendMessage(hRadio_FilesMv, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
				DragAcceptFiles(hWnd, true);
			else
				DragAcceptFiles(hWnd, false);
			break;
		case RB_NUMANDPAR:
		case RB_CHMSG:
		case RB_HUSER:
		case RB_MSGLIST: 
		case RB_NOINFO: 
			DragAcceptFiles(hWnd, false);
			break;
		}
	}

	// Handle files drop and drag
	if(uMsg == WM_DROPFILES && SendMessage(hRadio_FilesMv, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
	{
		int filesNumber = DragQueryFile((HDROP)wParam, 0xFFFFFFFF, NULL, 0);

		AddItem(hListBox, "Przenoszenie plikw...");
		char* temp = new char[MAX_PATH];
		char* fileName = new char[MAX_PATH];

		for(int i = 0; i < filesNumber; ++i)
		{
			ZeroMemory(temp, MAX_PATH);
			ZeroMemory(fileName, MAX_PATH);
			DragQueryFile((HDROP)wParam, i, temp, MAX_PATH);
			sprintf_s(fileName, sizeof(char)*MAX_PATH, "Nazwa pliku nr %d: %s", i+1, temp);
			AddItem(hListBox, fileName);
		}

		ZeroMemory(temp, MAX_PATH);
		sprintf_s(temp, sizeof(char)*MAX_PATH, "Upuszczone zostao %d", filesNumber);
		AddItem(hListBox, temp);

		delete temp;
		delete fileName;

		DragFinish((HDROP)wParam);
	}

	// Handle for messages to list box
	if(hWnd == hListBox && SendMessage(hCkeckBox_SayLst, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
		AddItem(hListBox, "Komunikat do list box'a");


	// Numbers and params of messages
	if(SendMessage(hRadio_NumAndParMsg, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
	{
		char* temp = new char[512];
		sprintf_s(temp, sizeof(char)*512, "%u %lu %lu", uMsg, lParam, wParam);
		AddItem(hListBox, temp);
		delete temp;
	}

	// Check messages to app event
	if(SendMessage(hRadio_ChMsgs, BM_GETCHECK, NULL, NULL) == BST_CHECKED)
	{
		switch(uMsg)
		{
		case WM_MOUSEMOVE:
			{
				AddItem(hListBox, "WM_MOUSEMOVE");
				char* temp = new char[512];
				sprintf_s(temp, sizeof(char)*512, "x=%d y=%d", (int)LOWORD(lParam), (int)HIWORD(lParam));
				SetWindowText(hWndApp, temp);
				// if left mouse button is pressed changes app caption to 'x=... y=..., lewy'
				if(wParam == MK_LBUTTON)
				{
					GetWindowText(hWndApp, temp, 512);
					sprintf_s(temp, sizeof(char)*512, "%s, %s", temp, "lewy");
					SetWindowText(hWndApp, temp);
				}
				// if right mouse button is pressed changes app caption to 'x=... y=..., prawy'
				if(wParam == MK_RBUTTON)
				{
					GetWindowText(hWndApp, temp, 512);
					sprintf_s(temp, sizeof(char)*512, "%s, %s", temp, "prawy");
					SetWindowText(hWndApp, temp);
				}
				// if control button is pressed changes app caption to 'x=... y=..., Ctrl'
				if(wParam == MK_CONTROL)
				{
					GetWindowText(hWndApp, temp, 512);
					sprintf_s(temp, sizeof(char)*512, "%s, %s", temp, "Ctrl");
					SetWindowText(hWndApp, temp);
				}
				delete temp;
			}
			break;
		case WM_NCMOUSEMOVE:
			{
				AddItem(hListBox, "WM_NCMOUSEMOVE");
				char* temp = new char[512];
				sprintf_s(temp, sizeof(char)*512, "x=%d y=%d", (int)LOWORD(lParam), (int)HIWORD(lParam));
				SetWindowText(hWndApp, temp);
				delete temp;
			}
			break;
		}
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmd, int nShowCmd)
{
	::hInstance = hInstance;

	WNDCLASSEX classWindow;
	ZeroMemory(&classWindow, sizeof(classWindow));
	classWindow.cbSize = sizeof(classWindow);
	classWindow.hInstance = hInstance;
	classWindow.lpfnWndProc = WndProcEvent;
	classWindow.hbrBackground = (HBRUSH) COLOR_WINDOW;
	classWindow.hCursor = LoadCursor(hInstance, IDC_ARROW);
	classWindow.hIcon = LoadIcon(hInstance, IDI_APPLICATION);
	classWindow.lpszClassName = "komunikatyWysylanie";
 
	RegisterClassEx(&classWindow);

	hWndApp = CreateWindowEx(
		NULL,
		"komunikatyWysylanie",
		"Unikalne",
		WS_OVERLAPPED | WS_MINIMIZEBOX | WS_SYSMENU,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		525,
		480,
		(HWND)NULL,
		(HMENU)NULL,
		hInstance,
		NULL
		);

	ShowWindow(hWndApp, nShowCmd);
 
	MSG mMsg;
	while(GetMessage(&mMsg, NULL, 0, 0))
	{
		TranslateMessage(&mMsg);
		DispatchMessage(&mMsg);
	}
 
	return static_cast<int>(mMsg.wParam);
}