// AplikacjaKonsolowaZWinAPI.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

//dodane
#include "Windows.h"
#include <iostream>
using namespace std;

//wiecej:
//http://msdn.microsoft.com/en-us/library/windows/desktop/ms724429(v=vs.85).aspx

int _tmain(int argc, _TCHAR* argv[])
{	
	bool czyPowtorzyc = false;
	do
	{
		//wyswietlanie wersji systemu - GetVersionEx
		OSVERSIONINFOEX wersja;
		ZeroMemory(&wersja,sizeof(OSVERSIONINFOEX));
		wersja.dwOSVersionInfoSize=sizeof(OSVERSIONINFOEX);
		GetVersionEx((OSVERSIONINFO*) &wersja);
		//strumienie bez Unicode
		std::cout << "[GetVersionEx]\n";
		std::cout << "Wersja systemu: " << wersja.dwMajorVersion << "." << wersja.dwMinorVersion << "." << wersja.dwBuildNumber;					
		LPSTR UnicodeToAnsi(LPCWSTR s); //deklaracja funkcji zdefiniowanej pod main
		std::cout << ", " << UnicodeToAnsi(wersja.szCSDVersion);
		std::cout << " (" << wersja.wServicePackMajor << "." << wersja.wServicePackMinor << ")\n";
		std::cout << "Typ systemu: ";
		switch(wersja.wProductType)
		{
			case VER_NT_DOMAIN_CONTROLLER: std::cout << "VER_NT_DOMAIN_CONTROLLER\n"; break;
			case VER_NT_SERVER: std::cout << "VER_NT_SERVER\n"; break;
			case VER_NT_WORKSTATION: std::cout << "VER_NT_WORKSTATION\n"; break;
			default: std::cout << "*** Nierozpoznany"; break;
		}

		LPSTR NazwaSystemu(DWORD majorVersion,DWORD minorVersion,BYTE productType);
		cout << NazwaSystemu(wersja.dwMajorVersion,wersja.dwMinorVersion,wersja.wProductType) << "\n";

		cout << "\n";

		//dodatkowe informacje - GetSystemMetrics
		cout << "[GetSystemMetrix]\n";
		cout << "Sposob uruchomienia: ";
		switch(GetSystemMetrics(SM_CLEANBOOT))
		{
			case 0: cout << "Normalny"; break;
			case 1: cout << "Safe Mode"; break;
			case 2: cout << "Safe Mode (z sieci)"; break;
			default: cout << "*** Nierozpoznany"; break;
		}
		cout << "\n";
	
		char bufor[256];
		_itoa_s(GetSystemMetrics(SM_CMOUSEBUTTONS),bufor,10);
		cout << "Ilosc przyciskow myszy: " << bufor << "\n\n";

		//Win32/Win64		
		cout << "[IsWow64Process]\n";
		BOOL bIsWow64 = FALSE;
	    if (!IsWow64Process(GetCurrentProcess(),&bIsWow64))
		{
			cout << "*** Nie udao si rozpozna platformy\n";
		}
		if(bIsWow64==TRUE) cout << "Win64 (WOW64)\n";
		else cout << "Win32";

		cout << "\n\n";

		//okno komunikatu
		int mbWynik = MessageBox(NULL,L"Czy powtrzy?",L"Tytu okna komunikatu",MB_YESNO | MB_ICONINFORMATION | MB_DEFBUTTON2);
		switch(mbWynik)
		{
			case IDYES: czyPowtorzyc = true; break;
			case IDNO: czyPowtorzyc = false; break;
		}
	} while(czyPowtorzyc);

	return 0;
}

//wejscie: Unicode wchar_t[]
//wyjscie: char[], null-terminated
LPSTR UnicodeToAnsi(LPCWSTR in)
{
	if (in==NULL) return NULL;
	int dlg=lstrlenW(in);
	if (dlg==0) 
	{
		CHAR *wynik=new CHAR[1];
		*wynik='\0';
		return wynik;
	}
	int cc=WideCharToMultiByte(CP_ACP,0,in,dlg,NULL,0,NULL,NULL);
	if (cc==0) return NULL;
	CHAR *wynik=new CHAR[cc+1];
	cc=WideCharToMultiByte(CP_ACP,0,in,dlg,wynik,cc,NULL,NULL);
	if (cc==0) 
	{
		delete[] wynik;
		return NULL;
	}
	wynik[cc]='\0';
	return wynik;
}

LPSTR NazwaSystemu(DWORD majorVersion,DWORD minorVersion,BYTE productType)
{
	switch(majorVersion)
	{
		case 5:
			switch(minorVersion)
			{
				case 0: return "Windows 2000";
				case 1: return "Windows XP";
				case 2: return "Windows XP x64 lub Windows Server 2003 (R2)";
				default: return "*** Nierozpoznany";
			}
			break;
		case 6:
			switch(minorVersion)
			{
				case 0: 
					if(productType == VER_NT_WORKSTATION) return "Windows Vista";
					else return "Windows Server 2008";
				case 1:
					if(productType == VER_NT_WORKSTATION) return "Windows 7";
					else return "Windows Server 2008 R2";
				case 2: 
					if(productType == VER_NT_WORKSTATION) return "Windows 8";
					else return "Windows Server 2012";
				default: return "*** Nierozpoznany";
			}
			break;
		default: return "*** Nierozpoznany";
	}
}