
// Internet_noUnicodeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Internet_noUnicode.h"
#include "Internet_noUnicodeDlg.h"
#include "afxdialogex.h"

//dodane
#include <wininet.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CInternet_noUnicodeDlg dialog




CInternet_noUnicodeDlg::CInternet_noUnicodeDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CInternet_noUnicodeDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CInternet_noUnicodeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, edit1);
	DDX_Control(pDX, IDC_EDIT2, edit2);
	DDX_Control(pDX, IDC_EDIT3, edit3);
	DDX_Control(pDX, IDC_EDIT4, edit4);
	DDX_Control(pDX, IDC_EDIT5, edit5);
	DDX_Control(pDX, IDC_EDIT6, edit6);
	DDX_Control(pDX, IDC_PICTURE, picture);
}

BEGIN_MESSAGE_MAP(CInternet_noUnicodeDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
//	ON_EN_CHANGE(IDC_EDIT1, &CInternet_noUnicodeDlg::OnEnChangeEdit1)
	ON_BN_CLICKED(IDC_BUTTON3, &CInternet_noUnicodeDlg::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON2, &CInternet_noUnicodeDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON1, &CInternet_noUnicodeDlg::OnBnClickedButton1)
	ON_WM_CLOSE()
END_MESSAGE_MAP()


// CInternet_noUnicodeDlg message handlers

BOOL CInternet_noUnicodeDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	edit5.SetWindowTextA("Nazwa lub IP:");
	edit6.SetWindowTextA("Wynik");

	// TODO: Add extra initialization here
	WSADATA wsaData;
	WSAStartup(MAKEWORD(1,0),&wsaData);
	OnBnClickedButton3();

    unsigned long typPolaczen=0;
    BOOL wynik=InternetGetConnectedState(&typPolaczen,0);
    bool polaczenieLAN=(typPolaczen & INTERNET_CONNECTION_LAN)>0;
    bool polaczenieModem=(typPolaczen & INTERNET_CONNECTION_MODEM)>0;
    bool polaczenieTrybOffline=(typPolaczen & INTERNET_CONNECTION_OFFLINE)>0;
    bool polaczenieProxy=(typPolaczen & INTERNET_CONNECTION_PROXY)>0;
    bool polaczenieRAS=(typPolaczen & INTERNET_RAS_INSTALLED)>0;

	char bufor[3];
	_itoa_s(typPolaczen,bufor,10);	

	CString czyPolaczenieAktywne = "Poczenie aktywne: ";
	czyPolaczenieAktywne+=(wynik?"tak":"nie");
	edit1.SetWindowTextA(czyPolaczenieAktywne);
    CString polaczenia="Poczenia ("+(CString)bufor+"): ";
    if(polaczenieLAN) polaczenia+="LAN; ";
    if(polaczenieModem) polaczenia+="modem; ";
    if(polaczenieTrybOffline) polaczenia+="offline; ";
    if(polaczenieProxy) polaczenia+="proxy; ";
    if(polaczenieRAS) polaczenia+="RAS; ";
    edit2.SetWindowTextA(polaczenia);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CInternet_noUnicodeDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CInternet_noUnicodeDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


//Po umieszczeniu na oknie Picture Control trzeba zmienic jego ID na IDC_PICTURE, a Type na Bitmap
void CInternet_noUnicodeDlg::OnBnClickedButton1()
{
    char temp[MAX_PATH];
    GetTempPath(MAX_PATH,temp);
	CString nazwaPliku= (CString)temp+"\\torun1.bmp";
    //ShowMessage(nazwaPliku);
    if(URLDownloadToFile(
        NULL,
        "http://www.fizyka.umk.pl/~jacek/img/torun.bmp",
        nazwaPliku.GetString(),
        0,
        NULL)==S_OK)
    {
		HBITMAP hBitmap = (HBITMAP)LoadImage(NULL, nazwaPliku, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE | LR_CREATEDIBSECTION | LR_DEFAULTSIZE); 
		picture.SetBitmap(hBitmap);
        MessageBox("Plik pobrany","Internet",MB_OK);
    }
    else MessageBox("Bd podczas pobierania pliku","Internet",MB_OK);
}


CString AdresIP(CString& nazwaKomputera,bool inicjacja=true,bool czyszczenie=true)
{
	//adujemy bibliotek Winsock
	if (inicjacja)
	{
		WORD wVersionRequested=MAKEWORD(1,0);
		WSADATA wsaData;
		WSAStartup(wVersionRequested,&wsaData);
	}

	//Sprawdzamy informacje o komputerze	
	hostent* pInfoKomputer=gethostbyname(nazwaKomputera.GetString());
	nazwaKomputera=pInfoKomputer->h_name;	
	//Konwertujemy adres IP protokou IPv4 na acuch z kropkami
	in_addr* pAdres=(in_addr*)(*(pInfoKomputer->h_addr_list));
	CString wynik=(CString)inet_ntoa(*pAdres);

	//Zwalniamy Winsock
	if (czyszczenie)
	{
		WSACleanup();
	}

	return wynik;
}

CString NazwaDNS(CString adresIP,bool inicjacja=true,bool czyszczenie=true)
{
	//adujemy bibliotek Winsock
	if (inicjacja)
	{
		WORD wVersionRequested=MAKEWORD(1,0);
		WSADATA wsaData;
		WSAStartup(wVersionRequested,&wsaData);
	}

	//Sprawdzamy informacje o komputerze
	unsigned long dwAdresIP=inet_addr((char*)adresIP.GetString());
	hostent* pInfoKomputer=gethostbyaddr((char*)&dwAdresIP,sizeof(unsigned long),AF_INET);
	CString wynik="";
	if (pInfoKomputer!=NULL) wynik=(CString)(pInfoKomputer->h_name);
	else MessageBox(NULL,"Pobranie nazwy komputera nie powiodo si","Internet",MB_OK);

	//Zwalniamy Winsock
	if (czyszczenie)
	{
		WSACleanup();
	}

	return wynik;
}


void CInternet_noUnicodeDlg::OnBnClickedButton2()
{
	char edit3Text[256]="";
	edit3.GetWindowTextA(edit3Text,256);
    if (edit3Text=="") return;
	wchar_t pierwszyZnak=edit3Text[0];
	if (pierwszyZnak>='0' && pierwszyZnak<='9') //adres IP czy nazwa DNS
	{
		edit4.SetWindowTextA(NazwaDNS(edit3Text,false,false));
        edit6.SetWindowTextA("Nazwa DNS:");
	}
	else
	{
		CString nazwaKomputera=edit3Text; //aby przekazac TCaption do AdresIP
		edit4.SetWindowTextA(AdresIP(nazwaKomputera,false,false));
		edit3.SetWindowTextA(nazwaKomputera);
        edit6.SetWindowTextA("Adres IP:");
	}
}

void CInternet_noUnicodeDlg::OnBnClickedButton3()
{
    //Pobieramy nazw lokalnego komputera
	
	wchar_t nazwaKomputera[MAX_COMPUTERNAME_LENGTH];
	unsigned long dlugoscNazwyKomputera;
	BOOL wynik = GetComputerNameW(nazwaKomputera,&dlugoscNazwyKomputera); //W wersji A jest bd
	
	char bufor[MAX_COMPUTERNAME_LENGTH];
	WideCharToMultiByte(CP_ACP,0,nazwaKomputera,-1,bufor,MAX_COMPUTERNAME_LENGTH,NULL,NULL);
	edit3.SetWindowText(bufor);		

	//Pobieramy IP lokalnego komputera
	OnBnClickedButton2();
}


void CInternet_noUnicodeDlg::OnClose()
{
	WSACleanup();

	CDialogEx::OnClose();
}
