
// KomunikatyDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Komunikaty.h"
#include "KomunikatyDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CKomunikatyDlg dialog




CKomunikatyDlg::CKomunikatyDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CKomunikatyDlg::IDD, pParent),
	  pRadioButton1(NULL),pRadioButton2(NULL),pRadioButton3(NULL),
	  kontrolkiDostepne(false)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CKomunikatyDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, listBox1);
	DDX_Control(pDX, IDC_EDIT1, edit1);
	DDX_Control(pDX, IDC_EDIT2, edit2);
}

BEGIN_MESSAGE_MAP(CKomunikatyDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()

	ON_BN_CLICKED(IDC_BUTTON1, &CKomunikatyDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CKomunikatyDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_RADIO1, &CKomunikatyDlg::OnBnClickedRadio1)
	ON_BN_CLICKED(IDC_RADIO2, &CKomunikatyDlg::OnBnClickedRadio1) //recznie
	ON_BN_CLICKED(IDC_RADIO3, &CKomunikatyDlg::OnBnClickedRadio1) //recznie
END_MESSAGE_MAP()


// CKomunikatyDlg message handlers

BOOL CKomunikatyDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	//Wybr jednego z pRadioButtonow
	pRadioButton1 = (CButton*)GetDlgItem(IDC_RADIO1);
	pRadioButton2 = (CButton*)GetDlgItem(IDC_RADIO2);
	pRadioButton3 = (CButton*)GetDlgItem(IDC_RADIO3); 
	pRadioButton2->SetCheck(true);	

	kontrolkiDostepne = true;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CKomunikatyDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CKomunikatyDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



//Dodana zmienna plistBox1 zwiazana z kontrolka
//Wylaczone sortowanie, wiele kolumn

//Komunikaty
LRESULT CKomunikatyDlg::WindowProc(UINT message, WPARAM wParam,LPARAM lParam)
{
	//Beep(100,10);

	if(!kontrolkiDostepne) goto Koniec;	

	if(pRadioButton1->GetCheck() && listBox1.m_hWnd!=NULL && message!=WM_CTLCOLOR && message!=WM_CTLCOLORLISTBOX)
	{
		wchar_t opis[256];
		_itow_s(message,opis,256,10);
		listBox1.AddString(opis);
		if(message==WM_MOUSEMOVE || message==WM_NCMOUSEMOVE) WyswietlPolozenieKursoraMyszy(lParam);
	}
	
	
	if(pRadioButton2->GetCheck() && listBox1.m_hWnd!=NULL) 
	{
		switch(message)
		{
			//Odmalowywanie okna
			case WM_PAINT: listBox1.AddString(L"WM_PAINT"); break;
	
			//Myszka
			case WM_MOUSEMOVE: 
				listBox1.AddString(L"WM_MOUSEMOVE");
				WyswietlPolozenieKursoraMyszy(lParam);
				break;
			case WM_NCMOUSEMOVE: 
				listBox1.AddString(L"WM_NCMOUSEMOVE");
				WyswietlPolozenieKursoraMyszy(lParam);
				break;
			//case WM_SETCURSOR: listBox1.AddString(L"WM_SETCURSOR"); break;
			case WM_LBUTTONDOWN: listBox1.AddString(L"WM_LBUTTONDOWN"); break;
			case WM_LBUTTONUP: listBox1.AddString(L"WM_LBUTTONUP"); break;
			case WM_LBUTTONDBLCLK: listBox1.AddString(L"WM_LBUTTONDBLCLK"); break;
			case WM_RBUTTONDOWN: listBox1.AddString(L"WM_RBUTTONDOWN"); break;
			case WM_RBUTTONUP: listBox1.AddString(L"WM_RBUTTONUP"); break;
			case WM_RBUTTONDBLCLK: listBox1.AddString(L"WM_RBUTTONDBLCLK"); break;
			case WM_MBUTTONDOWN: listBox1.AddString(L"WM_MBUTTONDOWN"); break;
			case WM_MBUTTONUP: listBox1.AddString(L"WM_MBUTTONUP"); break;
			case WM_MBUTTONDBLCLK: listBox1.AddString(L"WM_MBUTTONDBLCLK"); break;

			//Klawiatura
			case WM_KEYDOWN: listBox1.AddString(L"WM_KEYDOWN"); break;
			case WM_KEYUP: listBox1.AddString(L"WM_KEYUP"); break;
			case WM_CHAR: listBox1.AddString(L"WM_CHAR"); break;
		}
	}

	Koniec:
	//return DefWindowProc(message,wParam,lParam);
	return CDialogEx::WindowProc(message,wParam,lParam);
	//return 0;
}

BOOL CKomunikatyDlg::PreTranslateMessage(MSG* pMsg) 
{
	//tu nie bedzie WM_CHAR
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_ESCAPE) 
	{
		kontrolkiDostepne=false;
		Beep(300,200);
	}

	if(kontrolkiDostepne)
	{
		if(pRadioButton3->GetCheck() && listBox1.m_hWnd!=NULL && pMsg->message!=WM_CTLCOLOR && pMsg->message!=WM_CTLCOLORLISTBOX)
		{
			wchar_t opis[256];
			_itow_s(pMsg->message,opis,256,10);
			listBox1.AddString(opis);		

			if(pMsg->message==WM_MOUSEMOVE || pMsg->message==WM_NCMOUSEMOVE) WyswietlPolozenieKursoraMyszy(pMsg->lParam);
		}		
	}

	if(pMsg->message==WM_KEYDOWN) Beep(100,10);

	return CDialogEx::PreTranslateMessage(pMsg);
}

void CKomunikatyDlg::OnBnClickedButton1()
{
	kontrolkiDostepne = false;
	//this->CloseWindow(); //ukrywa okno
	//this->PostMessage(WM_CLOSE);
	//::PostMessage(this->m_hWnd,WM_CLOSE,0,0);
	::PostMessage(::FindWindow(NULL,L"Komunikaty"),WM_CLOSE,0,0);
}

void CKomunikatyDlg::OnBnClickedButton2()
{
	listBox1.ResetContent();
}


void CKomunikatyDlg::OnBnClickedRadio1()
{
	if(pRadioButton1->GetCheck() || pRadioButton3->GetCheck()) listBox1.SetColumnWidth(30);
	else listBox1.SetColumnWidth(120);

	OnBnClickedButton2();
}

void CKomunikatyDlg::WyswietlPolozenieKursoraMyszy(LPARAM lParam)
{
	wchar_t txt_x[256];
	wchar_t txt_y[256];

	//komunikat
	_itow_s(LOWORD(lParam),txt_x,256,10);
	_itow_s(HIWORD(lParam),txt_y,256,10);
	
	 //WinAPI
	/*
	POINT crPos;
	::GetCursorPos(&crPos);
	_itow_s(LOWORD(crPos.x),txt_x,256,10);
	_itow_s(LOWORD(crPos.y),txt_y,256,10);
	*/

	edit1.SetWindowText(txt_x);
	edit2.SetWindowText(txt_y);	
}