#include "Rejestr.h"

//nazwy kluczy nie sa czule na wielkosc liter
//ta funkcja nie uzywa transakcji
void ZapiszPolozenieOknaWRejestrze(HWND hWnd,HKEY uchwytKluczaPodstawowego,LPCTSTR nazwaKlucza)
{
	//odczytywanie geometrii
	RECT geometriaOkna;
	GetWindowRect(hWnd,&geometriaOkna);
	LONG x = geometriaOkna.left;
	LONG y = geometriaOkna.top;
	LONG w = geometriaOkna.right-geometriaOkna.left;
	LONG h = geometriaOkna.bottom-geometriaOkna.top;	
	
	const int dlugoscNazwyOkna = 256;
	char nazwaOkna[dlugoscNazwyOkna];
	GetWindowText(hWnd,nazwaOkna, dlugoscNazwyOkna); //na koncu \0 (null-terminated)

	//zapis do rejestru
	REGSAM prawaDostepu = KEY_WRITE;
	HKEY uchwytKlucza;
	DWORD czyKluczUtworzony;
	if (RegCreateKeyEx(uchwytKluczaPodstawowego, nazwaKlucza, 0, NULL,
			REG_OPTION_NON_VOLATILE, 
			prawaDostepu, 
			NULL, 
			&uchwytKlucza, &czyKluczUtworzony) != ERROR_SUCCESS)
	{
		MessageBox(hWnd,"Utworzenie lub otwarcie klucza rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
	}
	else
    {
		if(czyKluczUtworzony == REG_CREATED_NEW_KEY) 
		{
			strcpy_s(nazwaOkna,"Kolory - Rejestr");
			MessageBox(hWnd,"Pierwszy zapis geometrii okna do rejestru","Operacje na rejestrze",MB_OK | MB_ICONINFORMATION);
		}
		if(RegSetValueEx(uchwytKlucza,"txt",0,REG_SZ,(LPBYTE)nazwaOkna,strlen(nazwaOkna)+1) != ERROR_SUCCESS) MessageBox(hWnd,"Utworzenie wartoci \"txt\" rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
		if(RegSetValueEx(uchwytKlucza,"x",0,REG_DWORD,(LPBYTE)&x,sizeof(LONG)) != ERROR_SUCCESS) MessageBox(hWnd,"Utworzenie wartoci \"x\" rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
		if(RegSetValueEx(uchwytKlucza,"y",0,REG_DWORD,(LPBYTE)&y,sizeof(LONG)) != ERROR_SUCCESS) MessageBox(hWnd,"Utworzenie wartoci \"y\" rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
		if(RegSetValueEx(uchwytKlucza,"w",0,REG_DWORD,(LPBYTE)&w,sizeof(LONG)) != ERROR_SUCCESS) MessageBox(hWnd,"Utworzenie wartoci \"w\" rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
		if(RegSetValueEx(uchwytKlucza,"h",0,REG_DWORD,(LPBYTE)&h,sizeof(LONG)) != ERROR_SUCCESS) MessageBox(hWnd,"Utworzenie wartoci \"h\" rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
		RegCloseKey(uchwytKlucza);
	}
}

void OdczytajPolozenieOknaZRejestru(HWND hWnd,HKEY uchwytKluczaPodstawowego,LPCTSTR nazwaKlucza)
{
	if(hWnd == NULL)
	{
		MessageBox(hWnd,"Okno nie zostao jeszcze zainicjowane","Operacje na rejestrach",MB_OK|MB_ICONWARNING);
	}

	//miejsce na dane
	LONG x = 0;
	LONG y = 0;
	LONG w = 0;
	LONG h = 0;
	const int dlugoscNazwyOkna = 256;
	char nazwaOkna[dlugoscNazwyOkna];
	DWORD _dlugoscNazwyOkna = dlugoscNazwyOkna;
	DWORD _rozmiarLONG = sizeof(LONG);

	//zapis do rejestru	
	REGSAM prawaDostepu = KEY_READ;
	HKEY uchwytKlucza;

	//nie ma oddzielnej funkcji sprawdzajacej istnienie klucza (mozna wylistowac klucze)

	LONG wynik = RegOpenKeyEx(uchwytKluczaPodstawowego, nazwaKlucza, 
								REG_OPTION_NON_VOLATILE, 
								prawaDostepu,
								&uchwytKlucza);
	if (wynik != ERROR_SUCCESS)
	{
		if(wynik == ERROR_FILE_NOT_FOUND) MessageBox(hWnd,"Klucz o podanej nazwie nie istnieje","Operacje na rejestrze",MB_OK | MB_ICONINFORMATION);
		else MessageBox(hWnd,"Otwarcie klucza rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
	}
	else
    {
		if (RegQueryValueEx(uchwytKlucza,"txt",0,0,(LPBYTE)&nazwaOkna,&_dlugoscNazwyOkna) != ERROR_SUCCESS) MessageBox(hWnd,"Odczytanie wartoci \"txt\" rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
		if (RegQueryValueEx(uchwytKlucza,"x",0,0,(LPBYTE)&x,&_rozmiarLONG) != ERROR_SUCCESS) MessageBox(hWnd,"Odczytanie wartoci \"x\" rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
		if (RegQueryValueEx(uchwytKlucza,"y",0,0,(LPBYTE)&y,&_rozmiarLONG) != ERROR_SUCCESS) MessageBox(hWnd,"Odczytanie wartoci \"y\" rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
		if (RegQueryValueEx(uchwytKlucza,"w",0,0,(LPBYTE)&w,&_rozmiarLONG) != ERROR_SUCCESS) MessageBox(hWnd,"Odczytanie wartoci \"w\" rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
		if (RegQueryValueEx(uchwytKlucza,"h",0,0,(LPBYTE)&h,&_rozmiarLONG) != ERROR_SUCCESS) MessageBox(hWnd,"Odczytanie wartoci \"h\" rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
		RegCloseKey(uchwytKlucza);

		SetWindowPos(hWnd,NULL,x,y,w,h,SWP_SHOWWINDOW); //trzeba zmienic OnSize (uchwyt okna)
		SetWindowText(hWnd,nazwaOkna);
	}
}

void UsunKluczRejestruOpisujacyPolozenieOkna(HKEY uchwytKluczaPodstawowego,LPCTSTR nazwaKlucza)
{
	if(RegDeleteKey(uchwytKluczaPodstawowego,nazwaKlucza) == ERROR_SUCCESS) MessageBox(NULL,"Klucz zosta usunity","Operacje na rejestrach",MB_OK);
	else MessageBox(NULL,"Usunicie klucza nie powiodo si (prawdopodobnie brak klucza lub niewystarczajace uprawnienia)","Operacje na rejestrach",MB_OK | MB_ICONWARNING);
}

void AnalizaKlucza(HKEY uchwytKluczaPodstawowego,LPCTSTR nazwaKlucza)
{
	//zapis do rejestru	
	REGSAM prawaDostepu = KEY_READ;
	HKEY uchwytKlucza;
	LONG wynik = RegOpenKeyEx(uchwytKluczaPodstawowego, nazwaKlucza, 
								REG_OPTION_NON_VOLATILE, 
								prawaDostepu,
								&uchwytKlucza);
	if (wynik != ERROR_SUCCESS)
	{
		if(wynik == ERROR_FILE_NOT_FOUND) MessageBox(NULL,"Klucz o podanej nazwie nie istnieje","Operacje na rejestrze",MB_OK | MB_ICONINFORMATION);
		else MessageBox(NULL,"Otwarcie klucza rejestru nie jest moliwe (prawdopodobnie brak uprawnie)","Operacje na rejestrze",MB_OK | MB_ICONWARNING);
	}
	else
    {
		const int maksymalnaDlugoscOpisu = 65535;
	
	    char nazwaKlasy[MAX_PATH] = TEXT("");
	    DWORD dlugoscNazwyKlasy = MAX_PATH;
	    DWORD liczbaPodkluczy=0;
	    DWORD najdluzszaNazwaPodklucza;
	    DWORD maksymalnaDlugoscNazwyKlasy;
	    DWORD liczbaWartosci;
	    DWORD najdluzszaNazwaWartosci;
	    DWORD najwiekszaLiczbaBajtowWartosci;
	    DWORD rozmiarDeskryptoraBezpieczenstwa;
	    FILETIME czasOstatniegoZapisu;

		DWORD wynik = RegQueryInfoKey(
			uchwytKlucza,
			nazwaKlasy,
			&dlugoscNazwyKlasy,
			NULL,                    //zarezerwowany
			&liczbaPodkluczy,
			&najdluzszaNazwaPodklucza,
			&maksymalnaDlugoscNazwyKlasy,
			&liczbaWartosci,
			&najdluzszaNazwaWartosci,
			&najwiekszaLiczbaBajtowWartosci,
			&rozmiarDeskryptoraBezpieczenstwa,
			&czasOstatniegoZapisu);
	
		char opis[maksymalnaDlugoscOpisu] = "Klucz \"";
		strcat_s(opis,nazwaKlucza);
		strcat_s(opis,"\"\n");

		if(strlen(nazwaKlasy)>0)
		{
			strcat_s(opis,"Klasa: ");
			strcat_s(opis,nazwaKlasy);
			strcat_s(opis,"\n");
		}

		strcat_s(opis,"Ostatni zapis: ");		
		SYSTEMTIME czasSystemowyOstatniegoZapisu;
		FileTimeToSystemTime(&czasOstatniegoZapisu,&czasSystemowyOstatniegoZapisu);
		char bufor[64];
		GetDateFormat(
			LOCALE_SYSTEM_DEFAULT,
			NULL,
			&czasSystemowyOstatniegoZapisu,
			NULL,//"d MMMMM yyyy",
			bufor,
			64);
		strcat_s(opis,bufor);
		GetTimeFormat(
			LOCALE_SYSTEM_DEFAULT,
			NULL,
			&czasSystemowyOstatniegoZapisu,
			NULL,//"hh:mm:ss",
			bufor,
			64);
		strcat_s(opis,", ");
		strcat_s(opis,bufor);
		strcat_s(opis,"\n");		

		//Wyliczanie podkluczy az false RegEnumKeyEx nie zwroci ERROR_SUCCESS
	    if (liczbaPodkluczy > 0)
	    {
			char** nazwyPodkluczy = new char* [liczbaPodkluczy];

			const int maksymalnaDlugoscNazwyKlucza = 255;
			char nazwaPodklucza[maksymalnaDlugoscNazwyKlucza];   // buffer for subkey name
	        for (DWORD i=0; i<liczbaPodkluczy; i++) 
			{ 
	            DWORD dlugoscNazwy = maksymalnaDlugoscNazwyKlucza;
				wynik = RegEnumKeyEx(uchwytKlucza, i,
                     nazwaPodklucza, 
                     &dlugoscNazwy, 
                     NULL, 
                     NULL, 
                     NULL, 
                     &czasOstatniegoZapisu); 
				if (wynik == ERROR_SUCCESS) 
				{
					int dlugoscNazwyKlucza = strlen(nazwaPodklucza)+1; //uwzglednia \0
					nazwyPodkluczy[i]=new char[dlugoscNazwyKlucza];
	                strcpy_s(nazwyPodkluczy[i],dlugoscNazwyKlucza,nazwaPodklucza);
				}
			}

			//wyswietlanie podkluczy
			char bufor[255];
			_itoa_s(liczbaPodkluczy,bufor,10);
			strcat_s(opis,"\nPodklucze (");
			strcat_s(opis,bufor);
			strcat_s(opis,"):\n");
			for(unsigned int i=0;i<liczbaPodkluczy;++i)
			{
				strcat_s(opis,nazwyPodkluczy[i]);
				strcat_s(opis,"\n");
			}
		} 
		else strcat_s(opis,"\nBrak podkluczy\n");		

		//Wyliczanie wartosci
	    if (liczbaWartosci > 0) 
	    {
			char** nazwyWartosci = new char* [liczbaWartosci];

			const int maksymalnaDlugoscNazwyWartosci = 16383;
			char nazwaWartosci[maksymalnaDlugoscNazwyWartosci]; 
			for (DWORD i=0, wynik=ERROR_SUCCESS; i<liczbaWartosci; i++) 
			{ 	
	            DWORD dlugoscNazwyWartosci = maksymalnaDlugoscNazwyWartosci; 
				nazwaWartosci[0] = '\0'; 
				wynik = RegEnumValue(uchwytKlucza, i, 
	                nazwaWartosci, 
					&dlugoscNazwyWartosci, 
					NULL, 
					NULL,
					NULL,
					NULL);
 
	            if (wynik == ERROR_SUCCESS ) 
		        { 
					int dlugoscNazwyWartosci = strlen(nazwaWartosci)+1;
					nazwyWartosci[i] = new char[dlugoscNazwyWartosci];
					strcpy_s(nazwyWartosci[i],dlugoscNazwyWartosci,nazwaWartosci);
				}
			}

			//wyswietlanie wartosci
			char bufor[256];			
			_itoa_s(liczbaWartosci,bufor,10);
			strcat_s(opis,"\nWartoci (");
			strcat_s(opis,bufor);
			strcat_s(opis,"):\n");
			for(unsigned int i=0;i<liczbaWartosci;++i)
			{
				strcat_s(opis,nazwyWartosci[i]);
				strcat_s(opis,"\n");
			}			
		}
		else strcat_s(opis,"\nBrak wartoci\n");		

		RegCloseKey(uchwytKlucza);		

		MessageBox(NULL,opis,"Operacje na rejestrach",MB_OK);		
	} //koniec if-else czy istnieje klucz
}