//---------------------------------------------------------------------------

#include <windows.h>
#include <stdio.h>

#pragma hdrstop
#pragma argsused

//UWAGA! W menu Run,Parameters ustawione jest na "install"

//---------------------------------------------------------------------------

char* nazwaUslugi = "Moja usuga";
char* nazwaWyswietlana = "Przykadowa usuga";

void InstalujUsluge()
{
        printf("Proba laczenia z Service Control Managerem w celu instalacji uslugi...\n");

        SC_HANDLE scm=OpenSCManager(0,0,SC_MANAGER_CREATE_SERVICE); //service control manager
        if(scm)
        {
                char path[MAX_PATH];
                if(GetModuleFileName(0,path,sizeof(path)/sizeof(path[0]))>0)
                {
                        printf("Sciezka uslugi: %s\n",path);
                        SC_HANDLE usluga = CreateService(scm,nazwaUslugi,nazwaWyswietlana,
                                                         SERVICE_ALL_ACCESS, //prawa dostepu
                                                         SERVICE_WIN32_OWN_PROCESS, //usluga z wlasnym procesem
                                                         SERVICE_AUTO_START, //tryb uruchomienia
                                                         SERVICE_ERROR_IGNORE, //reakcja na bledy
                                                         path,
                                                         0,0,0,0,0);
                        if(usluga)
                        {
                                CloseServiceHandle(usluga);
                                printf("Instalacja uslugi powiodla sie\n");
                        }
                        else printf("Instalacja uslugi nie powiodla sie\n");
                }
                else printf("Nie mozna odczytac sciezki pliku uslugi\n");
                CloseServiceHandle(scm);
        }
        else printf("Service Control Manager nie jest dostpny\n");
}

void OdinstalujUsluge()
{
        printf("Proba laczenia z Service Control Managerem w celu odinstalowania uslugi...\n");

        SC_HANDLE scm=OpenSCManager(0,0,SC_MANAGER_CREATE_SERVICE);
        if(scm)
        {
                SC_HANDLE usluga=OpenService(scm,nazwaUslugi,SERVICE_QUERY_STATUS | DELETE);

                if(usluga)
                {
                        printf("Uzyskano dostep do uslugi\n");
                        SERVICE_STATUS stanUslugi;
                        if(QueryServiceStatus(usluga,&stanUslugi))
                        {
                                if(stanUslugi.dwCurrentState == SERVICE_STOPPED)
                                {
                                        printf("Usluga jest odinstalowywana\n");
                                        DeleteService(usluga);
                                }
                                else printf("Odinstalowanie uslugi nie powiodlo sie (nie jest zatrzymana)\n");
                        }
                        else printf("Ustalenie stanu usugi nie jest moliwe\n");
                        CloseServiceHandle(usluga);
                }
                else printf("Usluga nie jest dostepna\n");

                CloseServiceHandle(scm);
        }
        else printf("Service Control Manager nie jest dostpny\n");
}

SERVICE_STATUS stanUslugi;
SERVICE_STATUS_HANDLE uchwytStanuUslugi;
HANDLE zdarzenieZatrzymaniaUslugi=0;

void WINAPI ServiceControlHandler(DWORD kodKontrolny)
{
        switch(kodKontrolny)
        {
                case SERVICE_CONTROL_INTERROGATE: break; //to nieuzywane, bo scm zna status uslugi
                case SERVICE_CONTROL_SHUTDOWN: //wylaczenie systemu
                case SERVICE_CONTROL_STOP: //zatrzymanie uslugi
                        //printf("Usluga jest zatrzymywana\n");
                        stanUslugi.dwCurrentState=SERVICE_STOP_PENDING;
                        SetServiceStatus(uchwytStanuUslugi,&stanUslugi);
                        SetEvent(zdarzenieZatrzymaniaUslugi);
                        break;
        }
        SetServiceStatus(uchwytStanuUslugi, &stanUslugi);
}

void WINAPI ServiceMain(DWORD argc, char* argv[])
{
        stanUslugi.dwServiceType=SERVICE_WIN32;
        stanUslugi.dwCurrentState=SERVICE_STOPPED;
        stanUslugi.dwControlsAccepted=0;
        stanUslugi.dwWin32ExitCode=NO_ERROR;
        stanUslugi.dwServiceSpecificExitCode=NO_ERROR;
        stanUslugi.dwCheckPoint=0; //punkt kontrolny, zmienna inkrementowana podczas dlugich operacji (np. start), ktora moze byc przeslana do interfejsu
        stanUslugi.dwWaitHint=0; //przewidywany czas oczekiwania np. na start

        uchwytStanuUslugi = RegisterServiceCtrlHandler(nazwaUslugi,ServiceControlHandler);
        if(uchwytStanuUslugi)
        {
                printf("Zarejestrowano funkcje kontroli uslugi\n");
                stanUslugi.dwCurrentState=SERVICE_START_PENDING;
                SetServiceStatus(uchwytStanuUslugi,&stanUslugi);
                zdarzenieZatrzymaniaUslugi=CreateEvent(0,FALSE,FALSE,0);
                stanUslugi.dwControlsAccepted|=(SERVICE_ACCEPT_STOP|SERVICE_ACCEPT_SHUTDOWN); //o tych zdarzeniach mamy byc powiadamiani
                stanUslugi.dwCurrentState=SERVICE_RUNNING;
                SetServiceStatus(uchwytStanuUslugi,&stanUslugi);
                printf("Usluga jest uruchomiona\n");

                //wlasciwa petla uslugi
                do
                {
                        Beep(1000,100);
                }
                while(WaitForSingleObject(zdarzenieZatrzymaniaUslugi,5000) == WAIT_TIMEOUT);

                //konczenie uslugi
                printf("Dzialanie uslugi zostanie zatrzymane\n");
                stanUslugi.dwCurrentState=SERVICE_STOP_PENDING;
                SetServiceStatus(uchwytStanuUslugi,&stanUslugi);
                CloseHandle(zdarzenieZatrzymaniaUslugi);
                zdarzenieZatrzymaniaUslugi=0;
                stanUslugi.dwControlsAccepted&=~(SERVICE_ACCEPT_STOP|SERVICE_ACCEPT_SHUTDOWN);
                stanUslugi.dwCurrentState=SERVICE_STOPPED;
                SetServiceStatus(uchwytStanuUslugi,&stanUslugi);
                printf("Dzialanie uslugi zostalo zakonczone\n");
        }
        else printf("Zarejestrowanie funkcji kontroli nie byo moliwe\n");
}

void UruchomUsluge()
{
        //w jednym procesie mozemy miec kilka uslug
        SERVICE_TABLE_ENTRY tabelaUslug[]=
        {
                {nazwaUslugi,ServiceMain}, //my mamy tylko jedna usluge
                {NULL,NULL}
        };

        printf("Proba laczenia z Service Control Managerem i uruchomienia uslugi...\n");
        printf("(w razie niepowodzenia sprawd czy masz uprawnienia administratora)\n");
        StartServiceCtrlDispatcher(tabelaUslug);

        //powrot z tej funkcji dopiero, gdy wszystkie funkcje zostana zatrzymane
}

void __stdcall ZatrzymajUslugeZLiniiKomend();
void __stdcall UruchomUslugeZLiniiKomend();

int main(int argc, char* argv[])
{
        if(argc>1)
        {
                bool rozpoznanyArgument=false;
                if(lstrcmp(argv[1],"install")==0)
                {
                    rozpoznanyArgument=true;
                    InstalujUsluge();
                }
                if(lstrcmp(argv[1],"uninstall")==0)
                {
                    rozpoznanyArgument=true;
                    OdinstalujUsluge();
                }
                if(lstrcmp(argv[1],"stop")==0)
                {
                    rozpoznanyArgument=true;
                    ZatrzymajUslugeZLiniiKomend();
                }
                if(lstrcmp(argv[1],"start")==0)
                {
                    rozpoznanyArgument=true;
                    UruchomUslugeZLiniiKomend();
                }
                if(!rozpoznanyArgument) printf("Mozliwe argumenty: install, uninstall, start, stop.\n");
        }
        else UruchomUsluge();

        printf("\nOK.\n");
        return 0;
}

//Ponizszy kod potrzebny jest tylko, gdy chcemy zatrzymywac lub uruchamiac usluge z linii komend
//Zatrzymywanie zob. http://msdn.microsoft.com/en-us/library/ms686335(v=vs.85).aspx
//Uruchamianie zob.  http://msdn.microsoft.com/en-us/library/ms686315(v=VS.85).aspx

SC_HANDLE schSCManager;
SC_HANDLE schService;

//Nadmiarowe, bo nasza usluga nie ma uslug zaleznych
BOOL __stdcall ZatrzymajUslugiZalezne()
{
    DWORD i;
    DWORD dwBytesNeeded;
    DWORD dwCount;

    LPENUM_SERVICE_STATUS   lpDependencies = NULL;
    ENUM_SERVICE_STATUS     ess;
    SC_HANDLE               hDepService;
    SERVICE_STATUS_PROCESS  ssp;

    DWORD dwStartTime = GetTickCount();
    DWORD dwTimeout = 30000; // 30sec

    // Pass a zero-length buffer to get the required buffer size.
    if ( EnumDependentServices( schService, SERVICE_ACTIVE,
         lpDependencies, 0, &dwBytesNeeded, &dwCount ) )
    {
         // jesli powyzsza funkcja sie powiedzie nie ma do
         // zatrzymania uslug zaleznych
         return TRUE;
    }
    else
    {
        if ( GetLastError() != ERROR_MORE_DATA )
            return FALSE; // Nieoczekiwany blad

        // Alokujemy bufor dla uslug zaleznych
        lpDependencies = (LPENUM_SERVICE_STATUS) HeapAlloc(
            GetProcessHeap(), HEAP_ZERO_MEMORY, dwBytesNeeded );

        if ( !lpDependencies )
            return FALSE;

        __try {
            // Wyliczanie zaleznosci
            if ( !EnumDependentServices( schService, SERVICE_ACTIVE,
                lpDependencies, dwBytesNeeded, &dwBytesNeeded,
                &dwCount ) )
            return FALSE;

            for ( i = 0; i < dwCount; i++ )
            {
                ess = *(lpDependencies + i);
                // Otwieramy usluge
                hDepService = OpenService( schSCManager,
                   ess.lpServiceName,
                   SERVICE_STOP | SERVICE_QUERY_STATUS );

                if ( !hDepService )
                   return FALSE;

                __try {
                    //  Wyslamy stop code
                    if ( !ControlService( hDepService, 
                            SERVICE_CONTROL_STOP,
                            (LPSERVICE_STATUS) &ssp ) )
                    return FALSE;

                    // Czekamy na zatrzymanie uslugi
                    while ( ssp.dwCurrentState != SERVICE_STOPPED ) 
                    {
                        Sleep( ssp.dwWaitHint );
                        if ( !QueryServiceStatusEx(
                                hDepService,
                                SC_STATUS_PROCESS_INFO,
                                (LPBYTE)&ssp,
                                sizeof(SERVICE_STATUS_PROCESS),
                                &dwBytesNeeded ) )
                        return FALSE;

                        if ( ssp.dwCurrentState == SERVICE_STOPPED )
                            break;

                        if ( GetTickCount() - dwStartTime > dwTimeout )
                            return FALSE;
                    }
                }
                __finally
                {

                    CloseServiceHandle( hDepService );
                }
            }
        }
        __finally
        {
            // Zwalniamy bufor
            HeapFree( GetProcessHeap(), 0, lpDependencies );
        }
    }
    return TRUE;
}

void __stdcall ZatrzymajUslugeZLiniiKomend()
{
    //inicjalizacja
    SERVICE_STATUS_PROCESS ssp;
    DWORD dwStartTime = GetTickCount();
    DWORD dwBytesNeeded;
    DWORD dwTimeout = 30000; // 30 sekund
    DWORD dwWaitTime;

    printf("Proba laczenia z Service Control Managerem w celu zatrzymania uslugi...\n");

    schSCManager = OpenSCManager(
        NULL,
        NULL,
        SC_MANAGER_ALL_ACCESS);

    if (NULL == schSCManager)
    {
        printf("Nie udalo polaczyc sie Service Control Managerem  (%d)\n", GetLastError());
        return;
    }

    // Pobranie uchwytu do uslugi

    schService = OpenService(
        schSCManager,
        nazwaUslugi,
        SERVICE_STOP |                  // bedziemy zatrzymywac usluge
        SERVICE_QUERY_STATUS |
        SERVICE_ENUMERATE_DEPENDENTS);
 
    if (schService == NULL)
    { 
        printf("Otwarcie uslugi nie powiodlo sie (%d)\n", GetLastError());
        CloseServiceHandle(schSCManager);
        return;
    }

    // Sprawdzamy czy usluga nie jest juz czasem wylaczona

    if ( !QueryServiceStatusEx(
            schService,
            SC_STATUS_PROCESS_INFO,
            (LPBYTE)&ssp,
            sizeof(SERVICE_STATUS_PROCESS),
            &dwBytesNeeded ) )
    {
        printf("Nie powiodlo sie pobranie stanu uslugi (%d)\n", GetLastError());
        goto stop_cleanup;
    }

    if ( ssp.dwCurrentState == SERVICE_STOPPED )
    {
        printf("Usuga jest juz zatrzymana\n");
        goto stop_cleanup;
    }

    // Jesli usluga czeka na zatrzymanie to czekamy az sie zakonczy

    while ( ssp.dwCurrentState == SERVICE_STOP_PENDING )
    {
        printf("Usuga czeka na zakonczenie...\n");

        // Czekamy nie dluzej niz wskazuje zmienna WaitHint
        // dobry czas czekania to mniejwiecej 1/10 WaitHint
        // ale nie mniej niz 1 sekunda lub nie wiecej niz 10 sekund

        dwWaitTime = ssp.dwWaitHint / 10;

        if( dwWaitTime < 1000 )
            dwWaitTime = 1000;
        else if ( dwWaitTime > 10000 )
            dwWaitTime = 10000;

        Sleep( dwWaitTime );

        if ( !QueryServiceStatusEx(
                 schService,
                 SC_STATUS_PROCESS_INFO,
                 (LPBYTE)&ssp,
                 sizeof(SERVICE_STATUS_PROCESS),
                 &dwBytesNeeded ) )
        {
            printf("Pobranie stanu uslugi nie powiodlo sie (%d)\n", GetLastError());
            goto stop_cleanup;
        }

        if ( ssp.dwCurrentState == SERVICE_STOPPED )
        {
            printf("Usluga zatrzymana\n");
            goto stop_cleanup;
        }

        if ( GetTickCount() - dwStartTime > dwTimeout )
        {
            printf("Minal czas oczekiwania na zakonczenie uslugi\n");
            goto stop_cleanup;
        }
    }

    // Jesli usluga jest uruchomiona najpierw trzeba zatrzymac
    // zalezne od niej inne uslugi

    ZatrzymajUslugiZalezne();

    // Wysylamy stop code do uslugi

    if ( !ControlService(
            schService,
            SERVICE_CONTROL_STOP,
            (LPSERVICE_STATUS) &ssp ) )
    {
        printf( "Blad funkcji ControlService (%d)\n", GetLastError() );
        goto stop_cleanup;
    }

    // Czekamy az usluga sie zatrzyma

    while ( ssp.dwCurrentState != SERVICE_STOPPED )
    {
        Sleep( ssp.dwWaitHint );
        if ( !QueryServiceStatusEx(
                schService,
                SC_STATUS_PROCESS_INFO,
                (LPBYTE)&ssp,
                sizeof(SERVICE_STATUS_PROCESS),
                &dwBytesNeeded ) )
        {
            printf("Nie powiodlo sie pobranie statusu uslugi (%d)\n", GetLastError());
            goto stop_cleanup;
        }

        if ( ssp.dwCurrentState == SERVICE_STOPPED )
            break;

        if ( GetTickCount() - dwStartTime > dwTimeout )
        {
            printf( "Minal czas oczekiwania na zatrzymanie uslugi\n" );
            goto stop_cleanup;
        }
    }
    printf("Usluga zostala zatrzymana\n");

stop_cleanup:
    CloseServiceHandle(schService);
    CloseServiceHandle(schSCManager);
}

VOID __stdcall UruchomUslugeZLiniiKomend()
{
    SERVICE_STATUS_PROCESS ssStatus;
    DWORD dwOldCheckPoint;
    DWORD dwStartTickCount;
    DWORD dwWaitTime;
    DWORD dwBytesNeeded;

    printf("Proba laczenia z Service Control Managerem w celu zatrzymania uslugi...\n");
    //Pobieranie uchwytu do SCM

    schSCManager = OpenSCManager(
        NULL,                    // local computer
        NULL,                    // servicesActive database
        SC_MANAGER_ALL_ACCESS);  // full access rights

    if (NULL == schSCManager)
    {
        printf("Polaczenie z Service Control Manager nie powiodlo sie (%d)\n", GetLastError());
        return;
    }

    // Get a handle to the service.

    schService = OpenService(
        schSCManager,         // SCM database
        nazwaUslugi,            // name of service
        SERVICE_ALL_ACCESS);  // full access

    if (schService == NULL)
    {
        printf("Brak dostepu do uslugi (%d)\n", GetLastError());
        CloseServiceHandle(schSCManager);
        return;
    }

    // Check the status in case the service is not stopped.

    if (!QueryServiceStatusEx(
            schService,                     // handle to service
            SC_STATUS_PROCESS_INFO,         // information level
            (LPBYTE) &ssStatus,             // address of structure
            sizeof(SERVICE_STATUS_PROCESS), // size of structure
            &dwBytesNeeded ) )              // size needed if buffer is too small
    {
        printf("Pobranie stanu uslugi nie powiodlo sie (%d)\n", GetLastError());
        CloseServiceHandle(schService);
        CloseServiceHandle(schSCManager);
        return;
    }

    // Check if the service is already running. It would be possible
    // to stop the service here, but for simplicity this example just returns.

    if(ssStatus.dwCurrentState != SERVICE_STOPPED && ssStatus.dwCurrentState != SERVICE_STOP_PENDING)
    {
        printf("Nie mozna uruchomic uslugi (jest juz uruchomiona)\n");
        CloseServiceHandle(schService);
        CloseServiceHandle(schSCManager);
        return;
    }

    // Save the tick count and initial checkpoint.

    dwStartTickCount = GetTickCount();
    dwOldCheckPoint = ssStatus.dwCheckPoint;

    // Wait for the service to stop before attempting to start it.

    while (ssStatus.dwCurrentState == SERVICE_STOP_PENDING)
    {
        // Do not wait longer than the wait hint. A good interval is
        // one-tenth of the wait hint but not less than 1 second
        // and not more than 10 seconds.

        dwWaitTime = ssStatus.dwWaitHint / 10;

        if( dwWaitTime < 1000 )
            dwWaitTime = 1000;
        else if ( dwWaitTime > 10000 )
            dwWaitTime = 10000;

        Sleep( dwWaitTime );

        // Check the status until the service is no longer stop pending.

        if (!QueryServiceStatusEx(
                schService,                     // handle to service
                SC_STATUS_PROCESS_INFO,         // information level
                (LPBYTE) &ssStatus,             // address of structure
                sizeof(SERVICE_STATUS_PROCESS), // size of structure
                &dwBytesNeeded ) )              // size needed if buffer is too small
        {
            printf("Pobranie stanu uslugi nie powiodlo sie (%d)\n", GetLastError());
            CloseServiceHandle(schService);
            CloseServiceHandle(schSCManager);
            return;
        }

        if ( ssStatus.dwCheckPoint > dwOldCheckPoint )
        {
            // Continue to wait and check.

            dwStartTickCount = GetTickCount();
            dwOldCheckPoint = ssStatus.dwCheckPoint;
        }
        else
        {
            if(GetTickCount()-dwStartTickCount > ssStatus.dwWaitHint)
            {
                printf("Przekroczony czas oczekiwania na zakonczenie uslugi\n");
                CloseServiceHandle(schService);
                CloseServiceHandle(schSCManager);
                return;
            }
        }
    }

    // Attempt to start the service.

    if (!StartService(
            schService,  // handle to service
            0,           // number of arguments
            NULL) )      // no arguments
    {
        printf("Uruchomienie uslugi nie powiodlo sie (%d)\n", GetLastError());
        CloseServiceHandle(schService);
        CloseServiceHandle(schSCManager);
        return;
    }
    else printf("Trwa uruchamianie uslugi...\n");

    // Check the status until the service is no longer start pending.

    if (!QueryServiceStatusEx(
            schService,                     // handle to service
            SC_STATUS_PROCESS_INFO,         // info level
            (LPBYTE) &ssStatus,             // address of structure
            sizeof(SERVICE_STATUS_PROCESS), // size of structure
            &dwBytesNeeded ) )              // if buffer too small
    {
        printf("Pobranie stanu uslugi nie powiodlo sie (%d)\n", GetLastError());
        CloseServiceHandle(schService);
        CloseServiceHandle(schSCManager);
        return;
    }

    // Save the tick count and initial checkpoint.

    dwStartTickCount = GetTickCount();
    dwOldCheckPoint = ssStatus.dwCheckPoint;

    while (ssStatus.dwCurrentState == SERVICE_START_PENDING)
    {
        // Do not wait longer than the wait hint. A good interval is
        // one-tenth the wait hint, but no less than 1 second and no
        // more than 10 seconds.

        dwWaitTime = ssStatus.dwWaitHint / 10;

        if( dwWaitTime < 1000 )
            dwWaitTime = 1000;
        else if ( dwWaitTime > 10000 )
            dwWaitTime = 10000;

        Sleep( dwWaitTime );

        // Check the status again.

        if (!QueryServiceStatusEx(
            schService,             // handle to service
            SC_STATUS_PROCESS_INFO, // info level
            (LPBYTE) &ssStatus,             // address of structure
            sizeof(SERVICE_STATUS_PROCESS), // size of structure
            &dwBytesNeeded ) )              // if buffer too small
        {
            printf("Pobranie stanu uslugi nie powiodlo sie (%d)\n", GetLastError());
            break;
        }

        if ( ssStatus.dwCheckPoint > dwOldCheckPoint )
        {
            // Continue to wait and check.

            dwStartTickCount = GetTickCount();
            dwOldCheckPoint = ssStatus.dwCheckPoint;
        }
        else
        {
            if(GetTickCount()-dwStartTickCount > ssStatus.dwWaitHint)
            {
                // No progress made within the wait hint.
                break;
            }
        }
    }

    // Determine whether the service is running.

    if (ssStatus.dwCurrentState == SERVICE_RUNNING)
    {
        printf("Usluga zostala uruchomiona.\n");
    }
    else
    {
        printf("Usluga nie zostala uruchomiona. \n");
        printf("  Obecny stan: %d\n", ssStatus.dwCurrentState);
        printf("  Kod wyjscia: %d\n", ssStatus.dwWin32ExitCode);
        printf("  Check Point: %d\n", ssStatus.dwCheckPoint);
        printf("  Wait Hint: %d\n", ssStatus.dwWaitHint);
    }

    CloseServiceHandle(schService);
    CloseServiceHandle(schSCManager);
}


//---------------------------------------------------------------------------
