#ifndef DiskManagement_h
#define DiskManagement_h
#include <iostream>
#include <vector>
#include <sstream>
using namespace std;
class DiskManagement
{
  const char* disk;
  public:
    string GetDiskFreeSpaceEx_(bool);
    string GetDiskFreeSpace_();
    DiskManagement::DiskManagement(string d)
    {
      disk = d.c_str();
    }
    DiskManagement::DiskManagement(const char* d)
    {
      disk = d;
    }
};

string DiskManagement::GetDiskFreeSpaceEx_(bool humanReadable)
{
  unsigned __int64 FreeBytesAvailable,
                   TotalNumberOfBytes,
                   TotalNumberOfFreeBytes;
  ostringstream output;
  ::GetDiskFreeSpaceEx(this->disk,
                      (PULARGE_INTEGER)&FreeBytesAvailable,
                      (PULARGE_INTEGER)&TotalNumberOfBytes,
                      (PULARGE_INTEGER)&TotalNumberOfFreeBytes);
  if(humanReadable)
  {
    output << "Free MegaBytes Available for current user " << FreeBytesAvailable/(1024*1024) << "\r\n";
    output << "Total Number Of MegaBytes " << TotalNumberOfBytes/(1024*1024) << "\r\n";
    output << "Total Number Of Free MegaBytes overall " << TotalNumberOfFreeBytes/(1024*1024) << "\r\n";
  }
  else
  {
    output << "Free Bytes Available for current user " << FreeBytesAvailable << "\r\n";
    output << "Total Number Of Bytes " << TotalNumberOfBytes << "\r\n";
    output << "Total Number Of Free Bytes overall " << TotalNumberOfFreeBytes << "\r\n";
  }
  if(GetLastError())
    return "Error occured during checking drive, drive might not exist\r\n";
  return output.str();
}

string DiskManagement::GetDiskFreeSpace_()
{
  unsigned long SectorsPerCluster,
                BytesPerSector,
                NumberOfFreeClusters,
                TotalNumberOfClusters;
  GetDiskFreeSpace(this->disk,
                   &SectorsPerCluster,
                   &BytesPerSector,
                   &NumberOfFreeClusters,
                   &TotalNumberOfClusters);
  ostringstream output;
  output << "Sectors Per Cluster " << SectorsPerCluster << "\r\n";
  output << "Bytes Per Sector " << BytesPerSector << "\r\n";
  output << "Number Of Free Clusters " << NumberOfFreeClusters << "\r\n";
  output << "Total Number Of Clusters " << TotalNumberOfClusters << "\r\n";
  if(GetLastError())
    return "Error occured during checking drive, drive might not exist\r\n";
  return output.str();
}
#endif
