//---------------------------------------------------------------------------
#include "windows.h"
#include <conio.h>
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "VolumeManagement.h"
#include "DiskManagement.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
VolumeManagement x;
HANDLE file1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
  Memo1->Clear();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetLogicalDrives1Click(TObject *Sender)
{
  vector<string> vec = x.GetLogicalDrives_();
  AnsiString s;
  for(int i=0; i<vec.size(); i++)
  {
    Memo1->Lines->Append(vec[i].c_str());
  }
}
//---------------------------------------------------------------------------


void __fastcall TForm1::GetLogicalDriveStrings1Click(TObject *Sender)
{
  vector <string> vec = x.GetLogicalDriveStrings_();
  for(int i=0; i<vec.size(); i++)
  {
    Memo1->Lines->Append(vec[i].c_str());
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ClearButtonClick(TObject *Sender)
{
  Memo1->Clear();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetAllVolumesInformation1Click(TObject *Sender)
{
  vector<string> vec = x.GetLogicalDriveStrings_();
  for(int i=0; i<vec.size(); i++)
  {
    Memo1->Text = Memo1->Text + x.GetVolumeInformation_(vec[i].c_str()).c_str();
    Memo1->Text = Memo1->Text + "\r\n";
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetOneVolumeInformation1Click(TObject *Sender)
{
  string question = InputBox("Choose Drive",
                             "Enter Drive letter followed by :\\",
                             "C:\\").c_str();
  if(question.find(":\\")!=string::npos)
    Memo1->Text = Memo1->Text + x.GetVolumeInformation_(question.c_str()).c_str();
  else
    MessageBox(NULL, "Please follow drive letter with :\\", "Error", MB_ICONSTOP);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SetVolumeMountPoint1Click(TObject *Sender)
{
  string device = InputBox("Choose Device",
                           "Enter the full path to the mounted device",
                           "").c_str();
  string mount = InputBox("Choose Point",
                          "Enter the full path to the mount point",
                          "").c_str();
  if(device.find("\\")!=string::npos && mount.find("\\")!=string::npos)
  {
    try
    {
      if(x.SetVolumeMointPoint_(device.c_str(), mount.c_str()))
      {
        AnsiString out = "Device ";
        out = out + device.c_str() + " was mounted at point " + mount.c_str();
        Memo1->Lines->Append(out);
      }
      else
        MessageBox(NULL, "Device wasn't mounted at selected point.", "Error", MB_ICONSTOP);
    }
    catch(const char* ex)
    {
        MessageBox(NULL, ex, "Error", MB_ICONSTOP);
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DeleteVolumeMountPoint1Click(TObject *Sender)
{
  string mount = InputBox("Choose Point",
                          "Enter the full path to the mount point",
                          "").c_str();
  if(mount.find("\\")!=string::npos)
  {
    try
    {
      if(x.DeleteVolumeMountPoint_(mount.c_str()))
      {
        AnsiString out = "Device was unmounted from point ";
        Memo1->Lines->Append(out + mount.c_str() + " and folder was deleted");
      }
      else
        MessageBox(NULL, "Device wasn't unmounted from selected point.", "Error", MB_ICONSTOP);
    }
    catch(const char* ex)
    {
        MessageBox(NULL, ex, "Error", MB_ICONSTOP);
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetVolumeNameForVolumeMountPoint1Click(
      TObject *Sender)
{
  string mount = InputBox("Choose Point",
                          "Enter the full path to the mount point",
                          "").c_str();
  if(mount.find("\\")!=string::npos)
  {
    string volumename = x.GetVolumeNameForVolumeMountPoint_(mount.c_str()).c_str();
    if(volumename != "")
      Memo1->Lines->Append(volumename.c_str());
    else
      Memo1->Lines->Append("No device mounted under this pathname");
  }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::FindFirstVolume1Click(TObject *Sender)
{
  string fv = x.FindFirstVolume_();
  if(fv != "")
    Memo1->Lines->Append(fv.c_str());
  else
    Memo1->Lines->Append("Couldn't find volume");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetVolumePathNamesForVolumeName1Click(
      TObject *Sender)
{
  string volumename = InputBox("Enter VolumeName",
                               "Works only on mounted folders",
                               "").c_str();
  if(volumename.find("\\")!=string::npos)
  {
    string tmp = x.GetVolumePathNamesForVolumeName_(volumename.c_str());
    if(tmp != "")
      Memo1->Text = Memo1->Text + "\r\n" + tmp.c_str() + "\r\n";
    else
      Memo1->Lines->Append("Couldn't get pathnames for that volumename");
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::QueryDosDevice1Click(TObject *Sender)
{
  string drive = InputBox("Choose Drive",
                          "Enter Drive letter followed by :",
                          "C:").c_str();
  if(drive.find(":")!=string::npos && drive.find("\\") == string::npos)
  {
    string tmp = x.QueryDosDevice_(drive.c_str());
    if(tmp != "")
      Memo1->Lines->Append(tmp.c_str());
    else
      Memo1->Lines->Append("Couldn't get info about specified drive");
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FindNextVolume1Click(TObject *Sender)
{
  string fv = x.FindNextVolume_();
  if(fv == "")
    Memo1->Lines->Append("Couldn't find next volume");
  else if(fv == "1")
    Memo1->Lines->Append("Before looking for next volume find first volume");
  else
    Memo1->Lines->Append(fv.c_str());
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetAllDrivesType1Click(TObject *Sender)
{
  string tmp = x.GetDriveType_(x.GetLogicalDrives_());
  if(tmp!="")
    Memo1->Text = Memo1->Text + tmp.c_str();
  else
    Memo1->Lines->Append("No info gained");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetOneDriveType1Click(TObject *Sender)
{
  string disk = InputBox("Choose Drive",
                         "Enter Drive letter followed by :\\",
                         "C:\\").c_str();

  if(disk.find(":\\")!=string::npos)
  {
    string tmp = x.GetDriveType_(disk);
    if(tmp != "")
      Memo1->Text = Memo1->Text + tmp.c_str();
    else
      Memo1->Lines->Append("No info gained");
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetOneDiskFreeSpaceEx1Click(TObject *Sender)
{
  string disk = InputBox("Choose Drive",
                         "Enter Drive letter followed by :\\",
                         "C:\\").c_str();
  if(disk.find(":\\")!=string::npos)
  {
    DiskManagement dm(disk.c_str());
    Memo1->Text = Memo1->Text + dm.GetDiskFreeSpaceEx_(true).c_str();
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
    //cout << dm.GetDiskFreeSpace_();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetOneDiskFreeSpace1Click(TObject *Sender)
{
  string disk = InputBox("Choose Drive",
                         "Enter Drive letter followed by :\\",
                         "C:\\").c_str();
  if(disk.find(":\\")!=string::npos)
  {
    DiskManagement dm(disk.c_str());
    Memo1->Text = Memo1->Text + dm.GetDiskFreeSpace_().c_str();
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------


void __fastcall TForm1::GetAllDisksFreeSpaceEx1Click(TObject *Sender)
{
  vector<string> vec = x.GetLogicalDriveStrings_();
  for(int i=0; i<vec.size(); i++)
  {
    Memo1->Lines->Append(vec[i].c_str());
    DiskManagement dm(vec[i].c_str());
    Memo1->Text = Memo1->Text + dm.GetDiskFreeSpaceEx_(true).c_str() + "\r\n";
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetAllDisksFreeSpace1Click(TObject *Sender)
{
  vector<string> vec = x.GetLogicalDriveStrings_();
  for(int i=0; i<vec.size(); i++)
  {
    Memo1->Lines->Append(vec[i].c_str());
    DiskManagement dm(vec[i].c_str());
    Memo1->Text = Memo1->Text + dm.GetDiskFreeSpace_().c_str() + "\r\n";
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CreateDirectory1Click(TObject *Sender)
{
  string directory = InputBox("Enter path",
                              "Enter the full for the new directory",
                              "").c_str();
  if(directory.find(":\\")!=string::npos)
  {
    DWORD returnvalue;
    returnvalue = GetFileAttributes(directory.c_str());
    if(returnvalue == ((DWORD)-1))
    {
      if(CreateDirectory(directory.c_str(), NULL))
      {
         string out = directory.c_str();
         out = out + " was created";
         Memo1->Lines->Append(out.c_str());
      }
      else
        Memo1->Lines->Append("Wasn't able to create directory");
    }
    else
      Memo1->Lines->Append("Directory already exist");
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RemoveDirectory1Click(TObject *Sender)
{
  string directory = InputBox("Enter path",
                              "Enter the full path for directory to delete",
                              "").c_str();
  if(directory.find(":\\")!=string::npos)
  {
    if(RemoveDirectory(directory.c_str()))
    {
      string out = directory.c_str();
      out = out + " was deleted";
      Memo1->Lines->Append(out.c_str());
    }
    else
      Memo1->Lines->Append("Wasn't able to delete directory");
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetCurrentDirectory1Click(TObject *Sender)
{
  char Buffer[MAX_PATH];
  if(GetCurrentDirectory(MAX_PATH, Buffer))
    Memo1->Lines->Append(Buffer);
  else
    Memo1->Lines->Append("Couldn't get current directory");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SetCurrentDirectory1Click(TObject *Sender)
{
  string directory = InputBox("Enter path",
                              "Enter the full path for directory to delete",
                              "").c_str();
  if(directory.find(":\\")!=string::npos)
  {
    if(SetCurrentDirectory(directory.c_str()))
    {
      string out = "Current directory changed to ";
      out += directory;
      Memo1->Lines->Append(out.c_str());
    }
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------


void __fastcall TForm1::CreateFile1Click(TObject *Sender)
{
  string filename = InputBox("Enter path",
                             "Enter the full path for file to create",
                             "").c_str();
  if(filename.find(":\\")!=string::npos)
  {
    file1 = CreateFile(filename.c_str(),
                       GENERIC_ALL,
                       0,
                       NULL,
                       CREATE_NEW,
                       FILE_ATTRIBUTE_NORMAL,
                       NULL);
    if (GetLastError() == ERROR_FILE_EXISTS)
      Memo1->Lines->Append("File exists");
    else if (GetLastError() == ERROR_CANNOT_MAKE)
      Memo1->Lines->Append("Cannot create file");
    else if (file1 == INVALID_HANDLE_VALUE)
      Memo1->Lines->Append("Handle is invalid");
    else if (GetLastError() == ERROR_INVALID_NAME)
      Memo1->Lines->Append("Filename is invalid");
    else if (GetLastError() == ERROR_FILENAME_EXCED_RANGE)
      Memo1->Lines->Append("Filename or extension is too long");
    else
      Memo1->Lines->Append("File was created");
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::WriteFile1Click(TObject *Sender)
{
  string content = InputBox("Enter some text",
                            "Enter some text which will be added into file",
                            "").c_str();
  if(content.length() > 0)
  {
    char* Buforx = (char*) GlobalAlloc(GPTR, content.length());
    Buforx = (char*) content.c_str();
    unsigned long dwZapisane;
    if(!WriteFile(file1, Buforx, content.length(), &dwZapisane, NULL))
      Memo1->Lines->Append("Save to file failed");
    else
      Memo1->Lines->Append("Save to file successed");
    CloseHandle(file1);
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ReadFile1Click(TObject *Sender)
{
  unsigned long dwFileSize = GetFileSize(file1, NULL);
  char inBuffer[4096];
  OVERLAPPED stOverlapped = {0};
  if(ReadFile(file1, inBuffer, dwFileSize, NULL, &stOverlapped))
    Memo1->Text = Memo1->Text + inBuffer + "\r\n";
  else
    Memo1->Lines->Append("Couldn't read file content");
  CloseHandle(file1);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::OpenFile1Click(TObject *Sender)
{
  string filename = InputBox("Enter path",
                             "Enter the full path for file to open",
                             "").c_str();
  if(filename.length() > 0)
  {
    OFSTRUCT filestruct;
    file1 = (HANDLE) OpenFile(filename.c_str(), &filestruct, OF_READWRITE);
    if(GetLastError() == 0)
      Memo1->Lines->Append("File opened properly");
    else
      Memo1->Lines->Append("Couldn't open file");
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------


void __fastcall TForm1::CopyFile1Click(TObject *Sender)
{
  string filename = InputBox("Enter path",
                             "Enter the full path for file to copy",
                             "").c_str();

  string filename2 = InputBox("Enter path",
                             "Enter the full desination path for file copy",
                             "").c_str();
  if(filename.length() > 0 && filename.length() > 0)
  {
    if(!CopyFile(filename.c_str(), filename2.c_str(), true))
      Memo1->Lines->Append("Copying of the file failed, destination already exists!");
    else
      Memo1->Lines->Append("Copying file finished with success");
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EncryptFile1Click(TObject *Sender)
{
  string filename = InputBox("Enter path",
                             "Enter the full path for file to encrypt",
                             "").c_str();
  if(filename.find(":\\")!=string::npos)
  {
    if(EncryptFile(filename.c_str()))
      Memo1->Lines->Append("Encrypting file finished with success");
    else
      Memo1->Lines->Append("Encrypting of the file failed!");
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DecryptFile1Click(TObject *Sender)
{
  string filename = InputBox("Enter path",
                             "Enter the full path for file to decrypt",
                             "").c_str();
  if(filename.find(":\\")!=string::npos)
  {
    if(DecryptFile(filename.c_str(), NULL))
      Memo1->Lines->Append("Decrypting file finished with success");
    else
      Memo1->Lines->Append("Decrypting of the file failed!");
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DeleteFile1Click(TObject *Sender)
{
  string filename = InputBox("Enter path",
                             "Enter the full path for file to delete",
                             "").c_str();
  if(filename.find(":\\")!=string::npos)
  {
    if(DeleteFile(filename.c_str()))
      Memo1->Lines->Append("Deleteing file finished with success");
    else if(GetLastError() == 2)
      Memo1->Lines->Append("File doesn't exist, so cannot delete!");
    else
      Memo1->Lines->Append("Deleteing of the file failed!");
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetBinaryType1Click(TObject *Sender)
{
  string filename = InputBox("Enter path",
                             "Enter the full path for file to get binary type",
                             "").c_str();
  unsigned long result;
  if(filename.find(":\\")!=string::npos)
  {
    if(GetBinaryType(filename.c_str(), &result) && result < 7)
    {
      switch(result)
      {
        case SCS_32BIT_BINARY:
          Memo1->Lines->Append("A 32-bit Windows-based application");
          break;
        case SCS_64BIT_BINARY:
          Memo1->Lines->Append("A 64-bit Windows-based application");
          break;
        case SCS_DOS_BINARY:
          Memo1->Lines->Append("An MS-DOS  based application");
          break;
        case SCS_OS216_BINARY:
          Memo1->Lines->Append("A 16-bit OS/2-based application");
          break;
        case SCS_PIF_BINARY:
          Memo1->Lines->Append("A PIF file that executes an MS-DOS  based application");
          break;
        case SCS_POSIX_BINARY:
          Memo1->Lines->Append("A POSIX  based application");
          break;
        case SCS_WOW_BINARY:
          Memo1->Lines->Append("A 16-bit Windows-based application");
          break;
      }
    }
    else
      Memo1->Lines->Append("Only for binary files");
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CreateHardLink1Click(TObject *Sender)
{
  string filename = InputBox("Enter path",
                             "Enter the full path for file",
                             "").c_str();
  string filename2 = InputBox("Enter path",
                             "Enter the full path for hard link",
                             "").c_str();
  if(filename.find(":\\")!=string::npos && filename2.find(":\\")!=string::npos)
  {
    if(CreateHardLink(filename2.c_str(), filename.c_str(), NULL))
      Memo1->Lines->Append("Hardlink was created");
    else
      Memo1->Lines->Append("Hardlink wasn't created");
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------


void __fastcall TForm1::GetFileAttributes1Click(TObject *Sender)
{
  string filename = InputBox("Enter path",
                             "Enter the full path for file",
                             "").c_str();
  if(filename.find(":\\")!=string::npos)
  {
    DWORD flags = GetFileAttributes(filename.c_str());
    if(!GetLastError())
    {
  const struct
  {
    long flag;
    LPCTSTR name;
  }
  FlagNames[] = {
		{ FILE_ATTRIBUTE_ARCHIVE, _T("FILE_ATTRIBUTE_ARCHIVE") },
		{ FILE_ATTRIBUTE_COMPRESSED, _T("FILE_ATTRIBUTE_COMPRESSED") },
		{ FILE_ATTRIBUTE_DEVICE, _T("FILE_ATTRIBUTE_DEVICE") },
		{ FILE_ATTRIBUTE_DIRECTORY, _T("FILE_ATTRIBUTE_DIRECTORY") },
		{ FILE_ATTRIBUTE_ENCRYPTED, _T("FILE_ATTRIBUTE_ENCRYPTED") },
		{ FILE_ATTRIBUTE_HIDDEN, _T("FILE_ATTRIBUTE_HIDDEN") },
		{ FILE_ATTRIBUTE_NORMAL, _T("FILE_ATTRIBUTE_NORMAL") },
		{ FILE_ATTRIBUTE_NOT_CONTENT_INDEXED, _T("FILE_ATTRIBUTE_NOT_CONTENT_INDEXED") },
		{ FILE_ATTRIBUTE_OFFLINE, _T("FILE_ATTRIBUTE_OFFLINE") },
		{ FILE_ATTRIBUTE_READONLY, _T("FILE_ATTRIBUTE_READONLY") },
		{ FILE_ATTRIBUTE_REPARSE_POINT, _T("FILE_ATTRIBUTE_REPARSE_POINT") },
		{ FILE_ATTRIBUTE_SPARSE_FILE, _T("FILE_ATTRIBUTE_SPARSE_FILE") },
		{ FILE_ATTRIBUTE_SYSTEM, _T("FILE_ATTRIBUTE_SYSTEM") },
                { FILE_ATTRIBUTE_TEMPORARY, _T("FILE_ATTRIBUTE_TEMPORARY") },
		{ 0,NULL }};
  string str;
  static char buf[MAX_PATH]={0};
  for (int i=0; FlagNames[i].name; i++)
  {
    if (flags & FlagNames[i].flag)
    {
      str += FlagNames[i].name;
      str += "\r\n";
    }
  }
  Memo1->Text = Memo1->Text + str.c_str();

    }
    else
      Memo1->Lines->Append("Couldn't get info, maybe file doesn't exist?");
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------


void __fastcall TForm1::GetFileType1Click(TObject *Sender)
{
  if(file1 != NULL && file1 != INVALID_HANDLE_VALUE)
  {
    unsigned long tmp = GetFileType(file1);
    if(!GetLastError())
    {
      switch(tmp)
      {
        case FILE_TYPE_CHAR:
          Memo1->Lines->Append("The specified file is a character file, typically an LPT device or a console.");
          break;
        case FILE_TYPE_DISK:
          Memo1->Lines->Append("The specified file is a disk file.");
          break;
        case FILE_TYPE_PIPE:
          Memo1->Lines->Append("The specified file is a socket, a named pipe, or an anonymous pipe.");
          break;
        case FILE_TYPE_REMOTE:
          Memo1->Lines->Append("You should never see this");
          break;
        case FILE_TYPE_UNKNOWN:
          Memo1->Lines->Append("Either the type of the specified file is unknown, or the function failed.");
          break;
        default:
          Memo1->Lines->Append(tmp);
          break;
      }
    }
    else
      Memo1->Lines->Append("Something failed");
  }
  else
    Memo1->Lines->Append("Open file again, invalid handle to file");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::GetFileSize1Click(TObject *Sender)
{
  if(file1 != NULL && file1 != INVALID_HANDLE_VALUE)
  {
    unsigned long tmp = GetFileSize(file1, NULL);
    if(!GetLastError())
    {
      ostringstream out;
      out << "Filesize is " << tmp << " bytes";
      Memo1->Lines->Append(out.str().c_str());
    }
    else
      Memo1->Lines->Append("Something failed while getting size");
  }
  else
    Memo1->Lines->Append("Open file again, invalid handle to file");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MoveFile1Click(TObject *Sender)
{
  string filename = InputBox("Enter path",
                             "Enter the full path for file",
                             "").c_str();
  string filename2 = InputBox("Enter path",
                             "Enter the full path for new file path",
                             "").c_str();
  if(filename.find(":\\")!=string::npos && filename2.find(":\\")!=string::npos)
  {
    if(MoveFile(filename.c_str(), filename2.c_str()))
      Memo1->Lines->Append("File was moved");
    else
      Memo1->Lines->Append("File wasn't moved");
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FindFirstFile1Click(TObject *Sender)
{
  string filename = InputBox("Enter path",
                             "Enter the full path for files which you want to find\nAsterisk is allowed eg. C:\\*.txt",
                             "").c_str();
  if (filename.find(":\\")!=string::npos)
  {
    WIN32_FIND_DATA FindFileData;
    file1 = FindFirstFile(filename.c_str(), &FindFileData);
    if (file1 != INVALID_HANDLE_VALUE && !GetLastError())
    {
      ostringstream oss;
      oss << "Filename " << FindFileData.cFileName << "\r\n";
      const struct
      {
        long flag;
        LPCTSTR name;
      }
      FlagNames[] = {
	            { FILE_ATTRIBUTE_ARCHIVE, _T("FILE_ATTRIBUTE_ARCHIVE") },
                    { FILE_ATTRIBUTE_COMPRESSED, _T("FILE_ATTRIBUTE_COMPRESSED") },
                    { FILE_ATTRIBUTE_DEVICE, _T("FILE_ATTRIBUTE_DEVICE") },
                    { FILE_ATTRIBUTE_DIRECTORY, _T("FILE_ATTRIBUTE_DIRECTORY") },
                    { FILE_ATTRIBUTE_ENCRYPTED, _T("FILE_ATTRIBUTE_ENCRYPTED") },
                    { FILE_ATTRIBUTE_HIDDEN, _T("FILE_ATTRIBUTE_HIDDEN") },
                    { FILE_ATTRIBUTE_NORMAL, _T("FILE_ATTRIBUTE_NORMAL") },
                    { FILE_ATTRIBUTE_NOT_CONTENT_INDEXED, _T("FILE_ATTRIBUTE_NOT_CONTENT_INDEXED") },
                    { FILE_ATTRIBUTE_OFFLINE, _T("FILE_ATTRIBUTE_OFFLINE") },
                    { FILE_ATTRIBUTE_READONLY, _T("FILE_ATTRIBUTE_READONLY") },
                    { FILE_ATTRIBUTE_REPARSE_POINT, _T("FILE_ATTRIBUTE_REPARSE_POINT") },
                    { FILE_ATTRIBUTE_SPARSE_FILE, _T("FILE_ATTRIBUTE_SPARSE_FILE") },
                    { FILE_ATTRIBUTE_SYSTEM, _T("FILE_ATTRIBUTE_SYSTEM") },
                    { FILE_ATTRIBUTE_TEMPORARY, _T("FILE_ATTRIBUTE_TEMPORARY") },
      	            { 0,NULL }};
      string str;
      static char buf[MAX_PATH]={0};
      for (int i=0; FlagNames[i].name; i++)
      {
        if (FindFileData.dwFileAttributes & FlagNames[i].flag)
        {
          str += FlagNames[i].name;
          str += "\r\n";
        }
      }
      oss << "File Attributes\r\n" << str << "\r\n";
      oss << "File size ";
      oss << FindFileData.nFileSizeHigh*(MAXDWORD+1)+FindFileData.nFileSizeLow << "\r\n";
      oss << "Alternate Filename " << FindFileData.cAlternateFileName << "\r\n";
      Memo1->Text = Memo1->Text + oss.str().c_str();
    }
    else
      Memo1->Lines->Append("Something went wrong, try again or look for different files");
  }
  else
    Memo1->Lines->Append("Please fillfull requirements from inputbox");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FindNextFile1Click(TObject *Sender)
{
  if(file1 != INVALID_HANDLE_VALUE && file1 != NULL)
  {
    WIN32_FIND_DATA FindFileData;
    if (FindNextFile(file1, &FindFileData)&& !GetLastError())
    {
      ostringstream oss;
      oss << "Filename " << FindFileData.cFileName << "\r\n";
      const struct
      {
        long flag;
        LPCTSTR name;
      }
      FlagNames[] = {
	            { FILE_ATTRIBUTE_ARCHIVE, _T("FILE_ATTRIBUTE_ARCHIVE") },
                    { FILE_ATTRIBUTE_COMPRESSED, _T("FILE_ATTRIBUTE_COMPRESSED") },
                    { FILE_ATTRIBUTE_DEVICE, _T("FILE_ATTRIBUTE_DEVICE") },
                    { FILE_ATTRIBUTE_DIRECTORY, _T("FILE_ATTRIBUTE_DIRECTORY") },
                    { FILE_ATTRIBUTE_ENCRYPTED, _T("FILE_ATTRIBUTE_ENCRYPTED") },
                    { FILE_ATTRIBUTE_HIDDEN, _T("FILE_ATTRIBUTE_HIDDEN") },
                    { FILE_ATTRIBUTE_NORMAL, _T("FILE_ATTRIBUTE_NORMAL") },
                    { FILE_ATTRIBUTE_NOT_CONTENT_INDEXED, _T("FILE_ATTRIBUTE_NOT_CONTENT_INDEXED") },
                    { FILE_ATTRIBUTE_OFFLINE, _T("FILE_ATTRIBUTE_OFFLINE") },
                    { FILE_ATTRIBUTE_READONLY, _T("FILE_ATTRIBUTE_READONLY") },
                    { FILE_ATTRIBUTE_REPARSE_POINT, _T("FILE_ATTRIBUTE_REPARSE_POINT") },
                    { FILE_ATTRIBUTE_SPARSE_FILE, _T("FILE_ATTRIBUTE_SPARSE_FILE") },
                    { FILE_ATTRIBUTE_SYSTEM, _T("FILE_ATTRIBUTE_SYSTEM") },
                    { FILE_ATTRIBUTE_TEMPORARY, _T("FILE_ATTRIBUTE_TEMPORARY") },
      	            { 0,NULL }};
      string str;
      static char buf[MAX_PATH]={0};
      for (int i=0; FlagNames[i].name; i++)
      {
        if (FindFileData.dwFileAttributes & FlagNames[i].flag)
        {
          str += FlagNames[i].name;
          str += "\r\n";
        }
      }
      oss << "File Attributes\r\n" << str << "\r\n";
      oss << "File size ";
      oss << FindFileData.nFileSizeHigh*(MAXDWORD+1)+FindFileData.nFileSizeLow << "\r\n";
      oss << "Alternate Filename " << FindFileData.cAlternateFileName << "\r\n";
      Memo1->Text = Memo1->Text + oss.str().c_str();
    }
    else
      Memo1->Lines->Append("Something went wrong, try again or look for different files");
  }
  else
    Memo1->Lines->Append("Before looking for next file, search for first OR no more files");
}
//---------------------------------------------------------------------------



