
// TextSpeechDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TextSpeech.h"
#include "TextSpeechDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CTextSpeechDlg dialog




CTextSpeechDlg::CTextSpeechDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CTextSpeechDlg::IDD, pParent),
	  pGlos(NULL),pauza(true),tekstZPliku(false),tekst("")
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTextSpeechDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SLIDER1, SliderGlosnosc);
	DDX_Control(pDX, IDC_SLIDER2, SliderSzybkosc);
	DDX_Control(pDX, IDC_EDIT1, Edit1);
	DDX_Control(pDX, IDC_CHECK1, CheckBox1);
}

BEGIN_MESSAGE_MAP(CTextSpeechDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, &CTextSpeechDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CTextSpeechDlg::OnBnClickedButton2)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER1, &CTextSpeechDlg::OnNMCustomdrawSlider1)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_SLIDER2, &CTextSpeechDlg::OnNMCustomdrawSlider2)
END_MESSAGE_MAP()


// CTextSpeechDlg message handlers

BOOL CTextSpeechDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	
	//Ustawienia kontroler
	SliderGlosnosc.SetRange(0,100);
	SliderGlosnosc.SetTicFreq(1);
	SliderGlosnosc.SetPos(100);
	//
	SliderSzybkosc.SetRange(-10,10);
	SliderSzybkosc.SetTicFreq(1);
	SliderSzybkosc.SetPos(1);
	//
	CheckBox1.SetState(false);
	//
	Edit1.SetWindowTextW(L"This is sample text. Testing Microsoft Speech API using default voice.");

	//konfiguracja COM Microsoft Speach
	if(FAILED(CoInitialize(NULL))) return FALSE;
	HRESULT hr=CoCreateInstance(CLSID_SpVoice,NULL,CLSCTX_ALL,IID_ISpVoice,(void**)&pGlos);
	if(FAILED(hr)) return FALSE;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTextSpeechDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTextSpeechDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CTextSpeechDlg::OnBnClickedButton1()
{
	if(pGlos==NULL) return;
	pGlos->Resume();
	pauza=false;	
	Edit1.GetWindowTextW(tekst); //GetDlgItemText(IDC_EDIT1,tekst);
	tekstZPliku=CheckBox1.GetState()!=0;
	DWORD flagi=SPF_PURGEBEFORESPEAK|SPF_ASYNC;
	if(tekstZPliku) flagi|=SPF_IS_FILENAME;
	HRESULT wynik = pGlos->Speak(tekst,flagi,NULL);
	if(wynik!=S_OK) MessageBox(L"Przeczytanie tekstu nie powiodo si");
}


void CTextSpeechDlg::OnBnClickedButton2()
{
	if(pGlos==NULL) return;
	pauza=!pauza;
	if(pauza) pGlos->Pause();
	else pGlos->Resume();
}


void CTextSpeechDlg::OnNMCustomdrawSlider1(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);

	if(pGlos!=NULL) pGlos->SetVolume(SliderGlosnosc.GetPos());

	*pResult = 0;
}


void CTextSpeechDlg::OnNMCustomdrawSlider2(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	
	if(pGlos!=NULL) pGlos->SetRate(SliderSzybkosc.GetPos());

	*pResult = 0;
}
