#include <windows.h>
#include <sapi.h>
#define ID_BUTTON1 1001
#define ID_EDIT1 2001

const char klasaOkna[] = "Okno Gwne";
ISpVoice * pVoice = NULL;

BOOL mowa(HWND hWnd)
{
	HWND hEdit = GetDlgItem(hWnd, ID_EDIT1);
	
	int length = GetWindowTextLengthW(hEdit);
	LPWSTR txt = (LPWSTR)GlobalAlloc(GPTR, (length+1)*sizeof(LPWSTR));
	GetWindowTextW(hEdit, txt, length);

	CoInitialize(NULL);
	HRESULT hr = CoCreateInstance(CLSID_SpVoice, NULL, CLSCTX_ALL, IID_ISpVoice, (void **)&pVoice);
	if (SUCCEEDED(hr))
	{
		pVoice->Speak((LPCWSTR)txt, 0, NULL);
		pVoice->Release();
		pVoice = NULL;
	}
	CoUninitialize();

	return TRUE;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg)
	{
		case WM_COMMAND:
			switch (wParam)
			{
				case ID_BUTTON1:
				{
					mowa(hWnd);
				}
				break;
			}
		break;
		case WM_KEYDOWN:
			switch (wParam)
			{
				case VK_RETURN:
				{
					mowa(hWnd);
				}
				break;
			}
		break;
		case WM_CLOSE:
			DestroyWindow(hWnd);
		break;
		case WM_DESTROY:
			PostQuitMessage(0);
		break;
		default:
			return DefWindowProc(hWnd, msg, wParam, lParam);
	}

	return 0;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	WNDCLASSEX wc;

	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = 0;
	wc.lpfnWndProc = WndProc;
	wc.cbWndExtra = 0;
	wc.cbClsExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(hInstance, IDI_APPLICATION);
	wc.hIconSm = LoadIcon(hInstance, IDI_APPLICATION);
	wc.hCursor = LoadCursor(hInstance, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = "Okno Gwne";

	RegisterClassEx(&wc);

	HWND hWnd = CreateWindowEx(
		WS_EX_CLIENTEDGE, 
		klasaOkna,
		"Syntezator Mowy",
		WS_OVERLAPPEDWINDOW, 
		CW_USEDEFAULT, CW_USEDEFAULT, 
		720, 260,
		NULL,
		NULL, 
		hInstance, 
		NULL
	);

	HWND hEdit = CreateWindowEx(
		NULL,
		"EDIT",
		NULL,
		WS_CHILD | WS_VISIBLE | WS_BORDER,
		10, 10,
		680, 20,
		hWnd,
		(HMENU) ID_EDIT1,
		hInstance,
		NULL
	);

	HWND hButton= CreateWindowEx(
		NULL,
		"BUTTON",
		"Mw",
		WS_CHILD | WS_VISIBLE,
		300, 50,
		100, 50,
		hWnd,
		(HMENU) ID_BUTTON1,
		hInstance,
		NULL
	);

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	MSG Msg;

	while (GetMessage(&Msg, NULL, 0, 0) > 0)
	{
		TranslateMessage(&Msg);
		DispatchMessage(&Msg);
	}
	return Msg.wParam;
}