﻿using DemonstracjaPotrzebyZnaniaWinAPI.WinApi;
using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace DemonstracjaPotrzebyZnaniaWinAPI
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            textBox.Text = Handle.ToString();
        }

        private const uint WM_CLOSE = 16;
        private const uint WM_KEYDOWN = 0x0100;
        private const uint WM_KEYUP = 0x0101;
        private const uint WM_CHAR = 0x0102;
        private const uint WM_SYSKEYDOWN = 0x0104;
        private const uint WM_SYSKEYUP = 0x0105;

        [DllImport("user32.dll")]
        private static extern int SendMessage(IntPtr hWnd, uint Msg, IntPtr wParam, IntPtr lParam);

        private void btnDown_Click(object sender, EventArgs e)
        {
            //SendMessage(this.Handle, WM_CLOSE, 0, 0);
            //SendMessage(textBox.Handle, WM_KEYDOWN, 0x28, 0);
            SendMessage(textBox.Handle, WM_KEYDOWN, (IntPtr)Keys.Down, IntPtr.Zero);
        }

        private void btnUp_Click(object sender, EventArgs e)
        {
            SendMessage(textBox.Handle, WM_KEYDOWN, (IntPtr)Keys.Up, IntPtr.Zero);
        }

        private void btnLeft_Click(object sender, EventArgs e)
        {
            SendMessage(textBox.Handle, WM_KEYDOWN, (IntPtr)Keys.Left, IntPtr.Zero);
        }

        private void btnRight_Click(object sender, EventArgs e)
        {
            SendMessage(textBox.Handle, WM_KEYDOWN, (IntPtr)Keys.Right, IntPtr.Zero);
        }

        private void textBox_Leave(object sender, EventArgs e)
        {
            textBox.Focus();
        }





        // Źródła:
        //      [1] WYKONANIE: https://stackoverflow.com/questions/12761169/send-keys-through-sendinput-in-user32-dll
        //      [2] INPUT: https://docs.microsoft.com/en-us/windows/desktop/api/winuser/ns-winuser-taginput
        //      [3] SendInput(): https://docs.microsoft.com/en-us/windows/desktop/api/winuser/nf-winuser-sendinput
        //      [4] Inne pomysły na rozwiązanie: https://gamedev.stackexchange.com/questions/1859/handling-keyboard-and-mouse-input-win-api
        private void btnSelectAll_Click(object sender, EventArgs e)
        {
            InputStream.SendKeyDown(KeyCode.CONTROL);
            InputStream.SendKeyPress(KeyCode.KEY_A);
            InputStream.SendKeyUp(KeyCode.CONTROL);
        }
    }
}
