﻿using System;
using System.Runtime.InteropServices;

namespace DemonstracjaPotrzebyZnaniaWinAPI.WinApi
{
    // Typy reprezentujące róznego rodzaju input (mysz, klawiatura, sprzęt, itd.)



    // Wrapper określający typ inputu (abstrakcja) 
    [StructLayout(LayoutKind.Sequential)]
    internal struct INPUT
    {
        public uint Type;
        public MOUSEKEYBDHARDWAREINPUT Data;
    }

    // Typ jednoczący wszystkie rodzaje inputów (mysz + klawiatura + sprzęt) (agregat)
    [StructLayout(LayoutKind.Explicit)]
    internal struct MOUSEKEYBDHARDWAREINPUT
    {
        [FieldOffset(0)]
        public HARDWAREINPUT Hardware;

        [FieldOffset(0)]
        public KEYBDINPUT Keyboard;

        [FieldOffset(0)]
        public MOUSEINPUT Mouse;
    }

    // Typ reprezentujący key input (klawiatura)
    [StructLayout(LayoutKind.Sequential)]
    internal struct KEYBDINPUT
    {
        public ushort Vk;
        public ushort Scan;
        public uint Flags;
        public uint Time;
        public IntPtr ExtraInfo;
    }

    // Typ reprezentujący mouse input (mysz)
    [StructLayout(LayoutKind.Sequential)]
    internal struct MOUSEINPUT
    {
        public int X;
        public int Y;
        public uint MouseData;
        public uint Flags;
        public uint Time;
        public IntPtr ExtraInfo;
    }

    // Typ reprezentujący hardware input (sprzęt)
    [StructLayout(LayoutKind.Sequential)]
    internal struct HARDWAREINPUT
    {
        public uint Msg;
        public ushort ParamL;
        public ushort ParamH;
    }
}
