#include "Okno.h"
#include "Zasoby.h"

#include <commctrl.h>

#pragma region Podstawy
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	POINT pooenieOkna = { 100,100 };
	POINT rozmiarOkna = { 800,600 };
	if (!okno.Init(hInstance, pooenieOkna, rozmiarOkna))
	{
		MessageBox(NULL, "Inicjacja okna nie powioda si", "Aplikacja Win32", MB_OK | MB_ICONERROR);
		return EXIT_FAILURE;
	}
	else return okno.Run();
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return okno.WndProc(hWnd, uMsg, wParam, lParam);
}

bool COkno::Init(HINSTANCE uchwytAplikacji, POINT pooenieOkna, POINT rozmiarOkna)
{
	char nazwaOkna[] = "Aplikacja Windows";

	//WNDCLASSEX wc;
	wc.cbSize = sizeof(wc);
	wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc = (WNDPROC)::WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = uchwytAplikacji;
	wc.hIcon = LoadIcon(uchwytAplikacji, MAKEINTRESOURCE(IDI_ICON1));
	wc.hIconSm = LoadIcon(uchwytAplikacji, MAKEINTRESOURCE(IDI_ICON1));
	wc.hCursor = LoadCursor(uchwytAplikacji, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = nazwaOkna;

	if (RegisterClassEx(&wc) == 0) return false;

	DWORD stylOkna = WS_OVERLAPPEDWINDOW;

	uchwytOkna = CreateWindow(
		nazwaOkna,
		nazwaOkna,
		stylOkna,
		pooenieOkna.x, pooenieOkna.y,
		rozmiarOkna.x, rozmiarOkna.y,
		NULL,
		NULL,
		uchwytAplikacji,
		NULL);

	if (uchwytOkna == NULL) return false;	

	//Pokazanie okna
	ShowWindow(uchwytOkna, SW_SHOW);
	//UpdateWindow(uchwytOkna);

	return true;
}

WPARAM COkno::Run()
{
	//ptla gwna	
	MSG msg;
	while (GetMessage(&msg, NULL, 0, 0))
	{
		licznikKomunikatwRun++;
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}
#pragma endregion

LRESULT COkno::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	licznikKomunikatwWndProc++;
	switch (uMsg)
	{
	case WM_CREATE:
		//TwrzPrzyciski(hWnd);
		onCreate(hWnd, uMsg, wParam, lParam);
		break;
	case WM_COMMAND:
		ObsugaPrzyciskw(wParam);
		break;
	case WM_DESTROY:
		PostQuitMessage(EXIT_SUCCESS);
		break;
	case WM_SIZE:
		/*
		Beep(100, 100);
		{
			char sLicznikKomunikatwRun[255] = "";
			_itoa_s(licznikKomunikatwRun, sLicznikKomunikatwRun, 10);
			char sLicznikKomunikatwWndProc[255] = "";
			_itoa_s(licznikKomunikatwWndProc, sLicznikKomunikatwWndProc, 10);
			strcat_s(sLicznikKomunikatwRun, " ");
			strcat_s(sLicznikKomunikatwRun, sLicznikKomunikatwWndProc);
			SetWindowText(uchwytOkna, sLicznikKomunikatwRun);
		}
		*/
		onSize(hWnd, uMsg, wParam, lParam);
		break;

	//Kolory
	case WM_HSCROLL:
		RedrawWindow(hPanel, NULL, NULL, RDW_INVALIDATE);
		break;
	case WM_CTLCOLORSTATIC:		
	{
		HWND hCtl = (HWND)lParam;
		if (hCtl == hPanel)
		{
			DWORD dwPosR = SendMessage(hTrackBarR, TBM_GETPOS, 0, 0);
			DWORD dwPosG = SendMessage(hTrackBarG, TBM_GETPOS, 0, 0);
			DWORD dwPosB = SendMessage(hTrackBarB, TBM_GETPOS, 0, 0);
			HBRUSH hBrush = CreateSolidBrush(RGB((int)dwPosR, (int)dwPosG, (int)dwPosB));
			return (LRESULT)hBrush;
		}
		else return (LRESULT)GetStockObject(WHITE_BRUSH);
	}
		break;
	default:
		//automatyczne przetwarzanie komunikatw
		return DefWindowProc(hWnd, uMsg, wParam, lParam);
	}
}

#pragma region Przyciski
void COkno::TwrzPrzyciski(HWND uchwytOknaRodzica)
{
	hPrzyciskHello = CreateWindow(
		"Button",
		"Hello WinAPI!",
		WS_CHILD | WS_VISIBLE,
		30, 30, 200, 70, //geometria
		uchwytOknaRodzica,
		(HMENU)ID_BUTTON_HELLO,
		wc.hInstance,
		NULL);
	hPrzyciskZamknij = CreateWindow(
		"Button",
		"Zamknij",
		WS_CHILD | WS_VISIBLE,
		240, 30, 200, 70, //geometria
		uchwytOknaRodzica,
		(HMENU)ID_BUTTON_ZAMKNIJ,
		wc.hInstance,
		NULL);
}

void COkno::ObsugaPrzyciskw(WPARAM idPrzycisku)
{
	switch (idPrzycisku)
	{
	case ID_BUTTON_HELLO:
		MessageBox(uchwytOkna, "Hello, WinAPI!", "Witaj WinAPI!", MB_OK | MB_ICONINFORMATION);
		break;
	case ID_BUTTON_ZAMKNIJ:
		PostMessage(uchwytOkna, WM_CLOSE, 0, 0);
		break;
	}
}
#pragma endregion

#pragma region Kolory
HWND COkno::TwrzSuwak(HWND uchwytkOknaRodzica, UINT min, UINT max, UINT selMin, UINT selMax, RECT rect, HMENU id)
{
	INITCOMMONCONTROLSEX icc;
	icc.dwSize = sizeof(INITCOMMONCONTROLSEX);
	icc.dwICC = ICC_BAR_CLASSES;
	InitCommonControlsEx(&icc);

	HWND hWndTrackBar = CreateWindow(
		TRACKBAR_CLASS,
		"Kontrolka Trackbar",
		WS_CHILD | WS_VISIBLE | TBS_ENABLESELRANGE | TBS_AUTOTICKS,
		rect.left, rect.top,
		rect.right - rect.left, rect.bottom - rect.top,
		uchwytkOknaRodzica,
		id,
		wc.hInstance,
		NULL);
	
	SendMessage(hWndTrackBar, TBM_SETRANGE, (WPARAM)true, (LPARAM)MAKELONG(min, max));
	SendMessage(hWndTrackBar, TBM_SETPAGESIZE, 0, (LPARAM)4);
	SendMessage(hWndTrackBar, TBM_SETTICFREQ, 15, (LPARAM)1);
	SendMessage(hWndTrackBar, TBM_SETSEL, (WPARAM)FALSE, (LPARAM)MAKELONG(selMin, selMax));
	SendMessage(hWndTrackBar, TBM_SETPOS, (WPARAM)TRUE, (LPARAM)selMin);

	SetFocus(hWndTrackBar);

	return hWndTrackBar;
}

LRESULT COkno::onCreate(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int margines = 10;
	int szeroko = 270;
	int wysokoSuwakw = 30;

	//tworzymy
	hPanel = CreateWindow(
		"STATIC",
		"",
		WS_CHILD | WS_VISIBLE,
		margines, margines,
		szeroko, 120,
		hWnd,
		(HMENU)ID_PANEL,
		wc.hInstance,
		NULL);

	//suwaki
	RECT rect;
	rect.left = margines;
	rect.right = rect.left + szeroko;
	rect.top = 150;
	rect.bottom = rect.top + wysokoSuwakw;
	hTrackBarR = TwrzSuwak(hWnd, 0, 255, 0, 0, rect, (HMENU)ID_TRACKBAR_R);
	rect.top += 40;
	rect.bottom = rect.top + wysokoSuwakw;
	hTrackBarG = TwrzSuwak(hWnd, 0, 255, 0, 0, rect, (HMENU)ID_TRACKBAR_G);
	rect.top += 40;
	rect.bottom = rect.top + wysokoSuwakw;
	hTrackBarB = TwrzSuwak(hWnd, 0, 255, 0, 0, rect, (HMENU)ID_TRACKBAR_B);

	SetFocus(hTrackBarR);

	return 0;
}

LRESULT COkno::onSize(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	if (hWnd != uchwytOkna) return 0;

	RECT rectClientArea;
	GetClientRect(this->uchwytOkna, &rectClientArea);
	int szerokoObszaruKlienta = rectClientArea.right - rectClientArea.left;
	int wysokoObszaruKlienta = rectClientArea.bottom - rectClientArea.top;

	int margines = 10;
	int szeroko = szerokoObszaruKlienta - 2 * margines;
	int wysokoSuwakw = 30;

	SetWindowPos(
		hPanel, NULL, 
		margines, margines, szeroko, wysokoObszaruKlienta - 5 * margines - 3 * wysokoSuwakw, 
		SWP_NOACTIVATE);
	SetWindowPos(
		hTrackBarR, NULL,
		margines, wysokoObszaruKlienta - 3 * margines - 3 * wysokoSuwakw, szeroko, wysokoSuwakw,
		SWP_NOACTIVATE);
	SetWindowPos(
		hTrackBarG, NULL,
		margines, wysokoObszaruKlienta - 2 * margines - 2 * wysokoSuwakw, szeroko, wysokoSuwakw,
		SWP_NOACTIVATE);
	SetWindowPos(
		hTrackBarB, NULL,
		margines, wysokoObszaruKlienta - 1 * margines - 1 * wysokoSuwakw, szeroko, wysokoSuwakw,
		SWP_NOACTIVATE);

	return 0;
}
#pragma endregion
