﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace InformacjeODysku
{
    public static class WinAPI
    {
        /*
        BOOL GetDiskFreeSpaceExA(
            LPCSTR          lpDirectoryName,
            PULARGE_INTEGER lpFreeBytesAvailableToCaller,
            PULARGE_INTEGER lpTotalNumberOfBytes,
            PULARGE_INTEGER lpTotalNumberOfFreeBytes);
        */

        //[DllImport("kernel32.dll", EntryPoint = "GetDiskFreeSpaceEx")]
        //[DllImport("kernel32.dll", EntryPoint = "GetDiskFreeSpaceExA")]
        [DllImport("kernel32.dll", EntryPoint = "GetDiskFreeSpaceExW", CharSet = CharSet.Unicode)]
        public static extern bool GetDiskFreeSpace(
            string directoryName,
            out ulong freeBytesAvailableToCaller,
            out ulong totalNumberOfBytes,
            out ulong totalNumberOfFreeBytes);

        //(ulong, ulong, ulong)
        public static Tuple<ulong, ulong, ulong> GetDiskFreeSpaceInformation(string directoryName)
        {
            ulong freeBytesAvailableToCaller = ulong.MaxValue - 1, 
                totalNumberOfBytes, totalNumberOfFreeBytes = ulong.MaxValue - 1;
            GetDiskFreeSpace(
                directoryName, 
                out freeBytesAvailableToCaller, 
                out totalNumberOfBytes, 
                out totalNumberOfFreeBytes);
            Tuple<ulong, ulong, ulong> result = new Tuple<ulong, ulong, ulong>(
                freeBytesAvailableToCaller, 
                totalNumberOfBytes, 
                totalNumberOfFreeBytes);
            return result;
        }
        
    }
}
