﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.Timers;
using System.Threading;
using static WinApi;

namespace Konkurs2
{
    /// <summary>
    /// Logika interakcji dla klasy MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private int? pobierzZajętośćDysku(string katalogGłównyDysku)
        {
            long wolneMiejsceDlaUżytkownika = 0;
            long wolneMiejsceNaDysku = 0;
            long rozmiarDysku = 0;
            int? zajętośćProcenty = 0;
            if (GetDiskFreeSpaceEx(katalogGłównyDysku, ref wolneMiejsceDlaUżytkownika, ref rozmiarDysku, ref wolneMiejsceNaDysku))
            {
                zajętośćProcenty = (int)(100.0 * (rozmiarDysku - wolneMiejsceNaDysku) / rozmiarDysku);
            }
            else zajętośćProcenty = null;

            return zajętośćProcenty;
        }
        private void Button_Click(object sender, RoutedEventArgs e)
        {
            IntPtr hwnd = new WindowInteropHelper(this).Handle;
            //SendMessage(hwnd, WM_CLOSE, IntPtr.Zero, IntPtr.Zero);
            _MessageBox(hwnd, "Polskie litery: ąćżó", "Tytuł", 64);
            //MessageBeep(48);
            //MessageBox.Show(
            //    this,
            //    "Polskie litery: ąćżó",
            //    "tytuł",
            //    MessageBoxButton.OK);
            //WinExec(TextBox1.Text, StanOkna.Normalne);

            //string[] dyski = System.Environment.GetLogicalDrives();
            //foreach (string dysk in dyski)
            //    MessageBox.Show("Zajętość dysku: " + dysk + ": " + pobierzZajętośćDysku(dysk).ToString());

            //StringBuilder katalogWindows = new StringBuilder(MAX_PATH);
            //uint rozmiar = (uint)katalogWindows.Capacity;
            //GetWindowsDirectory(katalogWindows, rozmiar);
            //_MessageBox(hwnd, katalogWindows.ToString(), "Witam", 64);

            //TextBox1.Text = increment.ToString();
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            DispatcherTimer dt = new DispatcherTimer();
            dt.Interval = TimeSpan.FromSeconds(0.1);
            dt.Tick += dtTicker;
            dt.Start();
        }
        private int increment = 0;
        
        private void dtTicker(object sender, EventArgs e)
        {
            increment++;
            string color = WinApi.ToMediaColor(PobierzKolorPiksela(GetMousePosition())).ToString();
            TextBox1.Text = color;
            var converter = new System.Windows.Media.BrushConverter();
            var brush = (Brush)converter.ConvertFromString(color);
            panel1.Fill = brush;
        }

        private void TextBox_TextChanged(object sender, TextChangedEventArgs e)
        {

        }

    }
}
