﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace RównaniaKwadratowe
{
    /// <summary>
    /// Logika interakcji dla klasy MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private bool zainicjowane = false;

        public MainWindow()
        {
            InitializeComponent();
            zainicjowane = true;
            TextBox_TextChanged(this, null);
        }

        private void TextBox_TextChanged(object sender, TextChangedEventArgs e)
        {
            if (!zainicjowane) return;

            try
            {
                double a = double.Parse(tbA.Text);
                double b = double.Parse(tbB.Text);
                double c = double.Parse(tbC.Text);

                //double delta = b * b - 4 * a * c;
                //if (delta < 0) throw new Exception("Brak rozwiązań");
                //double x1 = (-b - Math.Sqrt(delta)) / (2 * a);
                //double x2 = (-b + Math.Sqrt(delta)) / (2 * a);
                RozwiązywaczRównańKwadratowych rrk = new RozwiązywaczRównańKwadratowych(a, b, c);

                tbX1.Text = rrk.X1.ToString();
                tbX2.Text = rrk.X2.ToString();
                tbStatus.Text = "Istnieją rozwiązania";
                tbStatus.Foreground = Brushes.Green;
            }
            catch(Exception exc)
            {
                tbX1.Text = "---";
                tbX2.Text = "---";
                tbStatus.Text = exc.Message;
                tbStatus.Foreground = Brushes.DarkRed;
            }
        }
    }
}
