﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace PrzeciągnijIUpuść
{
    /// <summary>
    /// Logika interakcji dla klasy MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private const string formatLista = "Format_Lista";
        private const string formatElementListy = "Format_ElementListy";

        Point? pozycjaPoczątkowa = null;

        private void ListBox_PreviewMouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            pozycjaPoczątkowa = e.GetPosition(this); 

        }

        private const int minimumDragDistance = 20;

        private void ListBox_MouseMove(object sender, MouseEventArgs e)
        {
            Point bieżącaPozycja = e.GetPosition(this);

            if (e.LeftButton == MouseButtonState.Released || !pozycjaPoczątkowa.HasValue) return;

            Vector przesunięcie = bieżącaPozycja - pozycjaPoczątkowa.Value;
            //if (przesunięcie.X > SystemParameters.MinimumHorizontalDragDistance ||
            //    przesunięcie.Y > SystemParameters.MinimumVerticalDragDistance)
            if (przesunięcie.X > minimumDragDistance || przesunięcie.Y > minimumDragDistance)
            {
                pozycjaPoczątkowa = null;

                ListBox lbSender = sender as ListBox;
                ListBoxItem przenoszonyElement = lbSender.GetItemAt(e.GetPosition(lbSender));
                string etykietyPrzenoszonychElementów = "";
                foreach (ListBoxItem item in lbSender.SelectedItems)
                    etykietyPrzenoszonychElementów += (item.Content as String) + "\n";
                if (przenoszonyElement != null)
                {
                    DataObject dane = new DataObject();
                    dane.SetData(formatLista, lbSender);
                    //dane.SetData(formatElementListy, przenoszonyElement);
                    dane.SetData(DataFormats.StringFormat, etykietyPrzenoszonychElementów);
                    DragDrop.DoDragDrop(lbSender, dane, DragDropEffects.Move | DragDropEffects.Copy);
                }
            }
        }

        private void ListBox_DragEnter(object sender, DragEventArgs e)
        {
            if (e.KeyStates.HasFlag(DragDropKeyStates.ControlKey)) e.Effects = DragDropEffects.Copy;
            else e.Effects = DragDropEffects.Move;
        }

        private void ListBox_Drop(object sender, DragEventArgs e)
        {
            ListBox lbSender = sender as ListBox;

            ListBox lbSource = e.Data.GetData(formatLista) as ListBox;
            //ListBoxItem przenoszonyElement = e.Data.GetData(formatElementListy) as ListBoxItem;

            //if (e.KeyStates.HasFlag(DragDropKeyStates.ControlKey)) przenoszonyElement = new ListBoxItem() { Content = przenoszonyElement.Content };
            //else lbSource.Items.Remove(przenoszonyElement);

            int indeks = lbSender.IndexFromPoint(e.GetPosition(lbSender));

            string[] etykietyElementów = (e.Data.GetData(DataFormats.StringFormat) as string).Split('\n');

            foreach (string etykieta in etykietyElementów)
            {
                ListBoxItem przenoszonyElement = new ListBoxItem() { Content = etykieta };
                if (indeks < 0) lbSender.Items.Add(przenoszonyElement);
                else lbSender.Items.Insert(indeks, przenoszonyElement);
            }
        }
    }
}
