﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DrugaAplikacjaMvvm.ModelWidoku
{
    using Model;
    using System.ComponentModel;
    using System.Windows.Input;

    class ModlWidokuDrugiejAplikacji : INotifyPropertyChanged
    {
        private ModelDrugiejAplikacjiMVVM model = new ModelDrugiejAplikacjiMVVM() { Napis = "" };

        public string Napis
        {
            get
            {
                return model.Napis;
            }
            set
            {
                model.Napis = value;
                onPropertyChanged();
            }
        }

        private void onPropertyChanged()
        {
            if (PropertyChanged != null) PropertyChanged(this, new PropertyChangedEventArgs(nameof(Napis)));
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private ICommand ustawUMK;

        public ICommand UstawUMK
        {
            get
            {
                if (ustawUMK == null)
                    ustawUMK = new RelayCommand(
                        (object p) =>
                        {
                            model.UstawUMK();
                            onPropertyChanged();
                        },
                        (object p) =>
                        {
                            return Napis != "UMK";
                        }
                        );
                return ustawUMK;

            }
        } 
    }
}
