﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using System.Windows.Media;

namespace PierwszaAplikacjaMvvm
{
    class DoubleToBrushConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            double d = (double)value;
            byte r = (byte)(d > 127 ? (512 - 2*d) : 255);
            byte g = (byte)((d < 127) ? (2 * d - 255) : 255);
            Color c = Color.FromRgb(r, g, 0);
            SolidColorBrush b = new SolidColorBrush(c);
            return b;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
