﻿using System.Media;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace DrugaAplikacjaMvvm
{
    using Microsoft.Xaml.Behaviors;


    public class DajFocus : Behavior<TextBox>
    {
        protected override void OnAttached()
        {
            this.AssociatedObject.Focus();
        }
    }

    public class DźwiękKlawiszy : Behavior<TextBox>
    {
        SoundPlayer sp = null;

        protected override void OnAttached()
        {
            TextBox textBox = this.AssociatedObject;
            if (textBox != null)
            {
                sp = new SoundPlayer("typewriter.wav");
                textBox.TextChanged += textBox_TextChanged;
            }
        }

        private void textBox_TextChanged(object sender, TextChangedEventArgs e)
        {
            sp.Play();
        }
    }

    public class ZamknięcieOknaEscapem : Behavior<Window>
    {
        public Key Klawisz { get; set; } = Key.None;

        protected override void OnAttached()
        {
            if (this.AssociatedObject != null)
            {
                (this.AssociatedObject as Window).PreviewKeyDown += zamknięcieOknaEscapem_PreviewKeyDown;
            }
        }

        private void zamknięcieOknaEscapem_PreviewKeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Klawisz) (sender as Window)?.Close();
        }
    }

    /*
    //to nie zadziała - potrzebna własność zależności
    public class PrzyciskZamykającyOkno : Behavior<Window>
    {
        private Button button = null;

        public Button Przycisk
        {
            get
            {
                return button;
            }
            set
            {
                if (button != null) button.Click -= button_Click;
                button = value;
                if (button != null) button.Click += button_Click;
            }
        }

        private void button_Click(object sender, RoutedEventArgs e)
        {
            this.AssociatedObject.Close();
        }
    }
    */

    public class PrzyciskZamykającyOkno : Behavior<Window>
    {
        public static readonly DependencyProperty PrzyciskProperty =
            DependencyProperty.Register(
                nameof(Przycisk),
                typeof(Button),
                typeof(PrzyciskZamykającyOkno),
                new PropertyMetadata(null, przyciskZmieniony));

        public Button Przycisk
        {
            get
            {
                return (Button)GetValue(PrzyciskProperty);
            }
            set
            {
                SetValue(PrzyciskProperty, value);
            }
        }

        private static void przyciskZmieniony(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            Window window = (d as PrzyciskZamykającyOkno).AssociatedObject;
            RoutedEventHandler button_Click = (object sender, RoutedEventArgs _e) => { window.Close(); };
            if (e.OldValue != null) (e.OldValue as Button).Click -= button_Click;
            if (e.NewValue != null) (e.NewValue as Button).Click += button_Click;
        }
    }

    public static class KlawiszZmieniającyKolorNaCzerwonyBehavior
    {
        public static Key GetKlawisz(DependencyObject d)
        {
            return (Key)d.GetValue(KlawiszProperty);
        }

        public static void SetKlawisz(DependencyObject d, Key value)
        {
            d.SetValue(KlawiszProperty, value);
        }

        public static readonly DependencyProperty KlawiszProperty =
            DependencyProperty.RegisterAttached(
                "Klawisz",
                typeof(Key),
                typeof(KlawiszZmieniającyKolorNaCzerwonyBehavior),
                new PropertyMetadata(Key.None, klawiszZmieniony));

        private static void klawiszZmieniony(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            Key klawisz = (Key)e.NewValue;
            if(d is Control)
            {
                (d as Control).PreviewKeyDown +=
                    (object sender, KeyEventArgs _e) =>
                    {
                        if (_e.Key == klawisz)
                        {
                            (d as Control).Background = System.Windows.Media.Brushes.Aqua;
                        }
                    };
            }
        }
    }
}
