﻿using System;
using System.ComponentModel;
using System.Windows.Input;

namespace RównaniaKwadratowe.ModelWidoku
{
    using Biblioteka;

    public class ModelWidokuDlaRozwiązywaczaRównańKwadratowych : INotifyPropertyChanged
    {
        private RównaniaKwadratowe model = new RównaniaKwadratowe();

        public double X1
        {
            get
            {
                if (!model.OstatnieRozwiązanie.HasValue) return 0;
                else return model.OstatnieRozwiązanie.Value.X1;
            }
        }

        public double X2
        {
            get
            {
                if (!model.OstatnieRozwiązanie.HasValue) return 0;
                else return model.OstatnieRozwiązanie.Value.X2;
            }
        }

        public double A { get; set; } = 1;
        public double B { get; set; } = -2;
        public double C { get; set; } = 1;

        private bool czyWspółczynnikiPoprawne()
        {
            return B * B - 4 * A * C >= 0;
        }

        private ICommand rozwiążCommand = null;        

        public ICommand Rozwiąż
        {
            get
            {
                if (rozwiążCommand == null)
                    rozwiążCommand = new RelayCommand(
                        (object parameter) =>
                        {
                            model.RozwiążRównanie(A, B, C);
                            onPropertyChanged();
                        },
                        (object parameter) =>
                        {
                            return czyWspółczynnikiPoprawne();
                        }
                        );
                return rozwiążCommand;
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void onPropertyChanged()
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(X1)));
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(X2)));
            }
        }
    }
}
