﻿using System;
using System.Windows.Input;

namespace RównaniaKwadratowe.ModelWidoku
{
    using Biblioteka;

    public struct WspółczynnikiRównaniaKwadratowego
    {
        public double A, B, C;

        public bool CzyWspółczynnikiPoprawne
        {
            get
            {
                double delta = B * B - 4 * A * C;
                return delta >= 0;
            }
        }
    }

    public class PolecenieRozwiązywaniaRównań : ICommand
    {
        private RównaniaKwadratowe model;

        public event EventHandler CanExecuteChanged
        {
            add
            {
                CommandManager.RequerySuggested += value;
            }
            remove
            {
                CommandManager.RequerySuggested -= value;
            }
        }

        public PolecenieRozwiązywaniaRównań(RównaniaKwadratowe model)
        {
            this.model = model;
        }        

        public bool CanExecute(object parameter)
        {
            if (parameter == null) return false;
            if (parameter is WspółczynnikiRównaniaKwadratowego)
            {
                WspółczynnikiRównaniaKwadratowego współczynniki = (WspółczynnikiRównaniaKwadratowego)parameter;
                return współczynniki.CzyWspółczynnikiPoprawne;
            }
            else throw new ArgumentException("Niepoprawny typ parametru", nameof(parameter));
        }

        public void Execute(object parameter)
        {
            if (parameter is WspółczynnikiRównaniaKwadratowego)
            {
                WspółczynnikiRównaniaKwadratowego współczynniki = (WspółczynnikiRównaniaKwadratowego)parameter;
                model.RozwiążRównanie(współczynniki.A, współczynniki.B, współczynniki.C);
                if (Executed != null) Executed(this, EventArgs.Empty);
            }
            else throw new ArgumentException("Niepoprawny typ parametru", nameof(parameter));
        }

        public event EventHandler Executed;
    }
}
