﻿using Microsoft.Xaml.Behaviors;

using System.Windows;
using System.Windows.Input;

namespace ZegarWPF
{
    class PrzesuwanieOkna : Behavior<Window>
    {
        protected override void OnAttached()
        {
            Window window = this.AssociatedObject;
            if(window != null)
            {
                window.KeyDown += window_KeyDown;
                window.MouseDown += window_MouseDown;
                window.MouseMove += window_MouseMove;
                window.MouseUp += window_MouseUp;
                window.Deactivated += window_Deactivated;
            }
        }

        private void window_KeyDown(object sender, System.Windows.Input.KeyEventArgs e)
        {
            if(e.Key == Key.Escape)
            {
                Window window = sender as Window;
                window.Close();
            }
        }

        private bool trwaPrzesuwanie = false;
        private Point początkowaPozycjaKursora;

        private void window_MouseDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            if (!trwaPrzesuwanie && e.LeftButton == MouseButtonState.Pressed)
            {
                Window window = sender as Window;
                trwaPrzesuwanie = true;
                początkowaPozycjaKursora = e.GetPosition(window);
            }
        }

        private void window_MouseMove(object sender, System.Windows.Input.MouseEventArgs e)
        {
            if(trwaPrzesuwanie)
            {
                Window window = sender as Window;
                Point pozycjaKursora = e.GetPosition(window);
                Vector przesunięcie = pozycjaKursora - początkowaPozycjaKursora;
                window.Left += przesunięcie.X;
                window.Top += przesunięcie.Y;
            }
        }

        private void window_MouseUp(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            if (trwaPrzesuwanie) trwaPrzesuwanie = false;
        }

        private void window_Deactivated(object sender, System.EventArgs e)
        {
            window_MouseUp(sender, null);
        }
    }
}
