﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadania.ModelWidoku
{
    public class Zadanie : INotifyPropertyChanged
    {
        private Model.Zadanie model;

        public string Opis
        {
            get
            {
                return model.Opis;
            }
        }

        public DateTime DataUtworzenia
        {
            get
            {
                return model.DataUtworzenia;
            }
        }

        public DateTime PlanowanyTerminRealizacji
        {
            get
            {
                return model.PlanowanyTerminRealizacji;
            }
        }

        public Model.PriorytetZadania Priorytet
        {
            get
            {
                return model.Priorytet;
            }
        }

        public bool CzyZrealizowane
        {
            set
            {
                model.CzyZrealizowane = value;
            }
            get
            {
                return model.CzyZrealizowane;
            }
        }

        public bool CzyZadaniePozostajeNiezrealizowanePoPlanowanymTerminieRealizacji
        {
            get
            {
                return !CzyZrealizowane && (DateTime.Now > PlanowanyTerminRealizacji);
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;
    }
}
