﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;

namespace KolekcjeWPF
{
    public class ZadanieConverter : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            string opis = (string)values[0];
            DateTime dataUtworzenia = DateTime.Now;
            DateTime dataRealizacji = (DateTime)values[1];
            int indeksPriorytetu = (int)values[2];
            if (indeksPriorytetu < 0) return null;
            Model.PriorytetZadania priorytet = (Model.PriorytetZadania)indeksPriorytetu;
            ModelWidoku.Zadanie zadanie = new ModelWidoku.Zadanie(opis, dataRealizacji, dataUtworzenia, priorytet, false);
            return zadanie;
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
